/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.keys;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.crypto.SecretKey;
import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.crypto.KeyUse;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.keys.KeyProvider;
import org.keycloak.keys.KeyProviderFactory;
import org.keycloak.keys.RsaKeyMetadata;
import org.keycloak.keys.SecretKeyMetadata;
import org.keycloak.models.KeyManager;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.Provider;
import org.keycloak.provider.ProviderFactory;

public class DefaultKeyManager
implements KeyManager {
    private static final Logger logger = Logger.getLogger(DefaultKeyManager.class);
    private final KeycloakSession session;
    private final Map<String, List<KeyProvider>> providersMap = new HashMap<String, List<KeyProvider>>();

    public DefaultKeyManager(KeycloakSession session) {
        this.session = session;
    }

    public KeyWrapper getActiveKey(RealmModel realm, KeyUse use, String algorithm) {
        KeyWrapper activeKey = this.getActiveKey(this.getProviders(realm), realm, use, algorithm);
        if (activeKey != null) {
            return activeKey;
        }
        logger.debugv("Failed to find active key for realm, trying fallback: realm={0} algorithm={1} use={2}", (Object)realm.getName(), (Object)algorithm, (Object)use.name());
        Optional<KeyProviderFactory> keyProviderFactory = this.session.getKeycloakSessionFactory().getProviderFactoriesStream(KeyProvider.class).map(KeyProviderFactory.class::cast).filter(kf -> kf.createFallbackKeys(this.session, use, algorithm)).findFirst();
        if (keyProviderFactory.isPresent()) {
            this.providersMap.remove(realm.getId());
            List<KeyProvider> providers = this.getProviders(realm);
            activeKey = this.getActiveKey(providers, realm, use, algorithm);
            if (activeKey != null) {
                logger.infov("No keys found for realm={0} and algorithm={1} for use={2}. Generating keys.", (Object)realm.getName(), (Object)algorithm, (Object)use.name());
                return activeKey;
            }
        }
        logger.errorv("Failed to create fallback key for realm: realm={0} algorithm={1} use={2", (Object)realm.getName(), (Object)algorithm, (Object)use.name());
        throw new RuntimeException("Failed to find key: realm=" + realm.getName() + " algorithm=" + algorithm + " use=" + use.name());
    }

    private KeyWrapper getActiveKey(List<KeyProvider> providers, RealmModel realm, KeyUse use, String algorithm) {
        Consumer<KeyWrapper> loggerConsumer = key -> {
            if (logger.isTraceEnabled()) {
                logger.tracev("Active key found: realm={0} kid={1} algorithm={2} use={3}", new Object[]{realm.getName(), key.getKid(), algorithm, use.name()});
            }
        };
        for (KeyProvider p : providers) {
            Optional<KeyWrapper> keyWrapper = p.getKeysStream().filter(key -> key.getStatus().isActive() && this.matches((KeyWrapper)key, use, algorithm)).peek(loggerConsumer).findFirst();
            if (!keyWrapper.isPresent()) continue;
            return keyWrapper.get();
        }
        return null;
    }

    public KeyWrapper getKey(RealmModel realm, String kid, KeyUse use, String algorithm) {
        if (kid == null) {
            logger.warnv("kid is null, can't find public key: realm={0}", (Object)realm.getName());
            return null;
        }
        Consumer<KeyWrapper> loggerConsumer = key -> {
            if (logger.isTraceEnabled()) {
                logger.tracev("Found key: realm={0} kid={1} algorithm={2} use={3}", new Object[]{realm.getName(), key.getKid(), algorithm, use.name()});
            }
        };
        for (KeyProvider p : this.getProviders(realm)) {
            Optional<KeyWrapper> keyWrapper = p.getKeysStream().filter(key -> Objects.equals(key.getKid(), kid) && key.getStatus().isEnabled() && this.matches((KeyWrapper)key, use, algorithm)).peek(loggerConsumer).findFirst();
            if (!keyWrapper.isPresent()) continue;
            return keyWrapper.get();
        }
        if (logger.isTraceEnabled()) {
            logger.tracev("Failed to find public key: realm={0} kid={1} algorithm={2} use={3}", new Object[]{realm.getName(), kid, algorithm, use.name()});
        }
        return null;
    }

    public Stream<KeyWrapper> getKeysStream(RealmModel realm, KeyUse use, String algorithm) {
        return this.getProviders(realm).stream().flatMap(p -> p.getKeysStream().filter(key -> key.getStatus().isEnabled() && this.matches((KeyWrapper)key, use, algorithm)));
    }

    public Stream<KeyWrapper> getKeysStream(RealmModel realm) {
        return this.getProviders(realm).stream().flatMap(KeyProvider::getKeysStream);
    }

    @Deprecated
    public KeyManager.ActiveRsaKey getActiveRsaKey(RealmModel realm) {
        KeyWrapper key = this.getActiveKey(realm, KeyUse.SIG, "RS256");
        return new KeyManager.ActiveRsaKey(key.getKid(), (PrivateKey)key.getPrivateKey(), (PublicKey)key.getPublicKey(), key.getCertificate());
    }

    @Deprecated
    public KeyManager.ActiveHmacKey getActiveHmacKey(RealmModel realm) {
        KeyWrapper key = this.getActiveKey(realm, KeyUse.SIG, "HS256");
        return new KeyManager.ActiveHmacKey(key.getKid(), key.getSecretKey());
    }

    @Deprecated
    public KeyManager.ActiveAesKey getActiveAesKey(RealmModel realm) {
        KeyWrapper key = this.getActiveKey(realm, KeyUse.ENC, "AES");
        return new KeyManager.ActiveAesKey(key.getKid(), key.getSecretKey());
    }

    @Deprecated
    public PublicKey getRsaPublicKey(RealmModel realm, String kid) {
        KeyWrapper key = this.getKey(realm, kid, KeyUse.SIG, "RS256");
        return key != null ? (PublicKey)key.getPublicKey() : null;
    }

    @Deprecated
    public Certificate getRsaCertificate(RealmModel realm, String kid) {
        KeyWrapper key = this.getKey(realm, kid, KeyUse.SIG, "RS256");
        return key != null ? key.getCertificate() : null;
    }

    @Deprecated
    public SecretKey getHmacSecretKey(RealmModel realm, String kid) {
        KeyWrapper key = this.getKey(realm, kid, KeyUse.SIG, "HS256");
        return key != null ? key.getSecretKey() : null;
    }

    @Deprecated
    public SecretKey getAesSecretKey(RealmModel realm, String kid) {
        KeyWrapper key = this.getKey(realm, kid, KeyUse.ENC, "AES");
        return key.getSecretKey();
    }

    @Deprecated
    public List<RsaKeyMetadata> getRsaKeys(RealmModel realm) {
        return this.getKeysStream(realm, KeyUse.SIG, "RS256").map(key -> {
            RsaKeyMetadata m = new RsaKeyMetadata();
            m.setCertificate((Certificate)key.getCertificate());
            m.setPublicKey((PublicKey)key.getPublicKey());
            m.setKid(key.getKid());
            m.setProviderId(key.getProviderId());
            m.setProviderPriority(key.getProviderPriority());
            m.setStatus(key.getStatus());
            return m;
        }).collect(Collectors.toList());
    }

    public List<SecretKeyMetadata> getHmacKeys(RealmModel realm) {
        return this.getKeysStream(realm, KeyUse.SIG, "HS256").map(key -> {
            SecretKeyMetadata m = new SecretKeyMetadata();
            m.setKid(key.getKid());
            m.setProviderId(key.getProviderId());
            m.setProviderPriority(key.getProviderPriority());
            m.setStatus(key.getStatus());
            return m;
        }).collect(Collectors.toList());
    }

    public List<SecretKeyMetadata> getAesKeys(RealmModel realm) {
        return this.getKeysStream(realm, KeyUse.ENC, "AES").map(key -> {
            SecretKeyMetadata m = new SecretKeyMetadata();
            m.setKid(key.getKid());
            m.setProviderId(key.getProviderId());
            m.setProviderPriority(key.getProviderPriority());
            m.setStatus(key.getStatus());
            return m;
        }).collect(Collectors.toList());
    }

    private boolean matches(KeyWrapper key, KeyUse use, String algorithm) {
        return use.equals((Object)key.getUse()) && key.getAlgorithmOrDefault().equals(algorithm);
    }

    private List<KeyProvider> getProviders(RealmModel realm) {
        List<Object> providers = this.providersMap.get(realm.getId());
        if (providers == null) {
            providers = realm.getComponentsStream(realm.getId(), KeyProvider.class.getName()).sorted(new ProviderComparator()).map(c -> {
                try {
                    ProviderFactory f = this.session.getKeycloakSessionFactory().getProviderFactory(KeyProvider.class, c.getProviderId());
                    KeyProviderFactory factory = (KeyProviderFactory)f;
                    KeyProvider provider = factory.create(this.session, c);
                    this.session.enlistForClose((Provider)provider);
                    return provider;
                }
                catch (Throwable t) {
                    logger.errorv(t, "Failed to load provider {0}", (Object)c.getId());
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
            this.providersMap.put(realm.getId(), providers);
        }
        return providers;
    }

    private static class ProviderComparator
    implements Comparator<ComponentModel> {
        private ProviderComparator() {
        }

        @Override
        public int compare(ComponentModel o1, ComponentModel o2) {
            int i = Long.compare(o2.get("priority", 0L), o1.get("priority", 0L));
            return i != 0 ? i : o1.getId().compareTo(o2.getId());
        }
    }
}

