/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.social.microsoft;

import com.fasterxml.jackson.databind.JsonNode;
import org.jboss.logging.Logger;
import org.keycloak.broker.oidc.AbstractOAuth2IdentityProvider;
import org.keycloak.broker.oidc.OAuth2IdentityProviderConfig;
import org.keycloak.broker.oidc.mappers.AbstractJsonUserAttributeMapper;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.IdentityBrokerException;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.provider.util.SimpleHttp;
import org.keycloak.broker.social.SocialIdentityProvider;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.KeycloakSession;
import org.keycloak.services.validation.Validation;

public class MicrosoftIdentityProvider
extends AbstractOAuth2IdentityProvider
implements SocialIdentityProvider {
    private static final Logger log = Logger.getLogger(MicrosoftIdentityProvider.class);
    public static final String AUTH_URL = "https://login.microsoftonline.com/common/oauth2/v2.0/authorize";
    public static final String TOKEN_URL = "https://login.microsoftonline.com/common/oauth2/v2.0/token";
    public static final String PROFILE_URL = "https://graph.microsoft.com/v1.0/me/";
    public static final String DEFAULT_SCOPE = "User.read";

    public MicrosoftIdentityProvider(KeycloakSession session, OAuth2IdentityProviderConfig config) {
        super(session, config);
        config.setAuthorizationUrl(AUTH_URL);
        config.setTokenUrl(TOKEN_URL);
        config.setUserInfoUrl(PROFILE_URL);
    }

    @Override
    protected boolean supportsExternalExchange() {
        return true;
    }

    @Override
    protected String getProfileEndpointForValidation(EventBuilder event) {
        return PROFILE_URL;
    }

    @Override
    protected BrokeredIdentityContext doGetFederatedIdentity(String accessToken) {
        try {
            JsonNode profile = SimpleHttp.doGet((String)PROFILE_URL, (KeycloakSession)this.session).auth(accessToken).asJson();
            return this.extractIdentityFromProfile(null, profile);
        }
        catch (Exception e) {
            throw new IdentityBrokerException("Could not obtain user profile from Microsoft Graph", (Throwable)e);
        }
    }

    @Override
    protected BrokeredIdentityContext extractIdentityFromProfile(EventBuilder event, JsonNode profile) {
        String username;
        String id = this.getJsonProperty(profile, "id");
        BrokeredIdentityContext user = new BrokeredIdentityContext(id);
        String email = this.getJsonProperty(profile, "mail");
        if (email == null && profile.has("userPrincipalName") && Validation.isEmailValid(username = this.getJsonProperty(profile, "userPrincipalName"))) {
            email = username;
        }
        user.setUsername(email != null ? email : id);
        user.setFirstName(this.getJsonProperty(profile, "givenName"));
        user.setLastName(this.getJsonProperty(profile, "surname"));
        if (email != null) {
            user.setEmail(email);
        }
        user.setIdpConfig(this.getConfig());
        user.setIdp((IdentityProvider)this);
        AbstractJsonUserAttributeMapper.storeUserProfileForMapper(user, profile, this.getConfig().getAlias());
        return user;
    }

    @Override
    protected String getDefaultScopes() {
        return DEFAULT_SCOPE;
    }
}

