/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.partialimport;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import org.keycloak.events.admin.OperationType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.partialimport.ClientsPartialImport;
import org.keycloak.partialimport.ErrorResponseException;
import org.keycloak.partialimport.GroupsPartialImport;
import org.keycloak.partialimport.IdentityProviderMappersPartialImport;
import org.keycloak.partialimport.IdentityProvidersPartialImport;
import org.keycloak.partialimport.PartialImport;
import org.keycloak.partialimport.PartialImportResult;
import org.keycloak.partialimport.PartialImportResults;
import org.keycloak.partialimport.RolesPartialImport;
import org.keycloak.partialimport.UsersPartialImport;
import org.keycloak.representations.idm.PartialImportRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.resources.admin.AdminEventBuilder;

public class PartialImportManager {
    private final List<PartialImport> partialImports = new ArrayList<PartialImport>();
    private final PartialImportRepresentation rep;
    private final KeycloakSession session;
    private final RealmModel realm;
    private final AdminEventBuilder adminEvent;

    public PartialImportManager(PartialImportRepresentation rep, KeycloakSession session, RealmModel realm, AdminEventBuilder adminEvent) {
        this.rep = rep;
        this.session = session;
        this.realm = realm;
        this.adminEvent = adminEvent;
        this.partialImports.add(new ClientsPartialImport());
        this.partialImports.add(new RolesPartialImport());
        this.partialImports.add(new IdentityProvidersPartialImport());
        this.partialImports.add(new IdentityProviderMappersPartialImport());
        this.partialImports.add(new GroupsPartialImport());
        this.partialImports.add(new UsersPartialImport());
    }

    public Response saveResources() {
        try {
            PartialImportResults results = new PartialImportResults();
            for (PartialImport partialImport : this.partialImports) {
                partialImport.prepare(this.rep, this.realm, this.session);
            }
            for (PartialImport partialImport : this.partialImports) {
                partialImport.removeOverwrites(this.realm, this.session);
                results.addAllResults(partialImport.doImport(this.rep, this.realm, this.session));
            }
            for (PartialImportResult result : results.getResults()) {
                switch (result.getAction()) {
                    case ADDED: {
                        this.fireCreatedEvent(result);
                        break;
                    }
                    case OVERWRITTEN: {
                        this.fireUpdateEvent(result);
                    }
                }
            }
            if (this.session.getTransactionManager().isActive()) {
                this.session.getTransactionManager().commit();
            }
            return Response.ok((Object)results).build();
        }
        catch (ModelDuplicateException e) {
            return ErrorResponse.exists(e.getLocalizedMessage());
        }
        catch (ErrorResponseException error) {
            if (this.session.getTransactionManager().isActive()) {
                this.session.getTransactionManager().setRollbackOnly();
            }
            return error.getResponse();
        }
        catch (Exception e) {
            if (this.session.getTransactionManager().isActive()) {
                this.session.getTransactionManager().setRollbackOnly();
            }
            return ErrorResponse.error(e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private void fireCreatedEvent(PartialImportResult result) {
        this.adminEvent.operation(OperationType.CREATE).resourcePath(result.getResourceType().getPath(), result.getId()).representation(result.getRepresentation()).success();
    }

    private void fireUpdateEvent(PartialImportResult result) {
        this.adminEvent.operation(OperationType.UPDATE).resourcePath(result.getResourceType().getPath(), result.getId()).representation(result.getRepresentation()).success();
    }
}

