/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InvalidObjectException;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Objects;
import org.keycloak.common.util.Time;
import org.keycloak.models.ClientModel;
import org.keycloak.models.delegate.ClientModelLazyDelegate;
import org.keycloak.protocol.oidc.AbstractClientConfigWrapper;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.utils.StringUtil;

public class OIDCClientSecretConfigWrapper
extends AbstractClientConfigWrapper {
    private OIDCClientSecretConfigWrapper(ClientModel client, ClientRepresentation clientRep) {
        super(client, clientRep);
    }

    public static OIDCClientSecretConfigWrapper fromClientModel(ClientModel client) {
        return new OIDCClientSecretConfigWrapper(client, null);
    }

    public static OIDCClientSecretConfigWrapper fromClientRepresentation(ClientRepresentation clientRep) {
        return new OIDCClientSecretConfigWrapper(null, clientRep);
    }

    public String getSecret() {
        if (this.clientModel != null) {
            return this.clientModel.getSecret();
        }
        return this.clientRep.getSecret();
    }

    public String getId() {
        if (this.clientModel != null) {
            return this.clientModel.getId();
        }
        return this.clientRep.getId();
    }

    public String getName() {
        if (this.clientModel != null) {
            return this.clientModel.getName();
        }
        return this.clientRep.getName();
    }

    public void removeClientSecretRotationInfo() {
        this.setAttribute("client.secret.expiration.time", null);
        this.setAttribute("client.secret.remaining.expiration.time", null);
        this.removeClientSecretRotated();
    }

    public void removeClientSecretRotated() {
        if (this.hasRotatedSecret()) {
            this.setAttribute("client.secret.rotated", null);
            this.setAttribute("client.secret.rotated.creation.time", null);
            this.setAttribute("client.secret.rotated.expiration.time", null);
        }
    }

    public int getClientSecretCreationTime() {
        String creationTime = this.getAttribute("client.secret.creation.time");
        return StringUtil.isBlank((String)creationTime) ? 0 : Integer.parseInt(creationTime);
    }

    public void setClientSecretCreationTime(int creationTime) {
        this.setAttribute("client.secret.creation.time", String.valueOf(creationTime));
    }

    public boolean hasRotatedSecret() {
        return StringUtil.isNotBlank((String)this.getAttribute("client.secret.rotated")) && StringUtil.isNotBlank((String)this.getAttribute("client.secret.rotated.creation.time"));
    }

    public String getClientRotatedSecret() {
        return this.getAttribute("client.secret.rotated");
    }

    public void setClientRotatedSecret(String secret) {
        this.setAttribute("client.secret.rotated", secret);
    }

    public int getClientRotatedSecretCreationTime() {
        String rotatedCreationTime = this.getAttribute("client.secret.rotated.creation.time");
        if (StringUtil.isNotBlank((String)rotatedCreationTime)) {
            return Integer.parseInt(rotatedCreationTime);
        }
        return 0;
    }

    public void setClientRotatedSecretCreationTime(Integer rotatedTime) {
        this.setAttribute("client.secret.rotated.creation.time", rotatedTime != null ? String.valueOf(rotatedTime) : null);
    }

    public void setClientSecretCreationTime() {
        this.setClientSecretCreationTime(Time.currentTime());
    }

    public void setClientRotatedSecretCreationTime() {
        this.setClientRotatedSecretCreationTime(Time.currentTime());
    }

    public void updateClientRepresentationAttributes(ClientRepresentation rep) {
        rep.getAttributes().put("client.secret.rotated", this.getAttribute("client.secret.rotated"));
        rep.getAttributes().put("client.secret.creation.time", this.getAttribute("client.secret.creation.time"));
        rep.getAttributes().put("client.secret.expiration.time", this.getAttribute("client.secret.expiration.time"));
        rep.getAttributes().put("client.secret.rotated.creation.time", this.getAttribute("client.secret.rotated.creation.time"));
        rep.getAttributes().put("client.secret.rotated.expiration.time", this.getAttribute("client.secret.rotated.expiration.time"));
    }

    public boolean hasClientSecretExpirationTime() {
        return this.getClientSecretExpirationTime() > 0;
    }

    public int getClientSecretExpirationTime() {
        String expiration = this.getAttribute("client.secret.expiration.time");
        return expiration == null ? 0 : Integer.parseInt(expiration);
    }

    public void setClientSecretExpirationTime(Integer expiration) {
        this.setAttribute("client.secret.expiration.time", expiration != null ? String.valueOf(expiration) : null);
    }

    public boolean isClientSecretExpired() {
        if (this.hasClientSecretExpirationTime()) {
            return this.getClientSecretExpirationTime() < Time.currentTime();
        }
        return false;
    }

    public int getClientRotatedSecretExpirationTime() {
        if (this.hasClientRotatedSecretExpirationTime()) {
            return Integer.valueOf(this.getAttribute("client.secret.rotated.expiration.time"));
        }
        return 0;
    }

    public void setClientRotatedSecretExpirationTime(Integer expiration) {
        this.setAttribute("client.secret.rotated.expiration.time", expiration != null ? String.valueOf(expiration) : null);
    }

    public boolean hasClientRotatedSecretExpirationTime() {
        return StringUtil.isNotBlank((String)this.getAttribute("client.secret.rotated.expiration.time"));
    }

    public boolean isClientRotatedSecretExpired() {
        if (this.hasClientRotatedSecretExpirationTime()) {
            return this.getClientRotatedSecretExpirationTime() < Time.currentTime();
        }
        return true;
    }

    public boolean validateRotatedSecret(String secret) {
        if (this.hasRotatedSecret()) {
            if (this.isClientRotatedSecretExpired()) {
                return false;
            }
        } else {
            return false;
        }
        return MessageDigest.isEqual(secret.getBytes(), this.getClientRotatedSecret().getBytes());
    }

    public String toJson() {
        ObjectMapper mapper = new ObjectMapper();
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
            map.put("clientId", this.getId());
            map.put("clientName", this.getName());
            map.put("secretCreationTimeSeconds", this.getClientSecretCreationTime());
            map.put("secretCreationTime", sdf.format(Time.toDate((int)this.getClientSecretCreationTime())));
            map.put("secretExpirationTimeSeconds", this.getClientSecretExpirationTime());
            map.put("secretExpirationTime", sdf.format(Time.toDate((int)this.getClientSecretExpirationTime())));
            map.put("rotatedSecretCreationTimeSeconds", this.getClientRotatedSecretCreationTime());
            map.put("rotatedSecretCreationTime", sdf.format(Time.toDate((int)this.getClientRotatedSecretCreationTime())));
            map.put("rotatedSecretExpirationTimeSeconds", this.getClientRotatedSecretExpirationTime());
            map.put("rotatedSecretExpirationTime", sdf.format(Time.toDate((int)this.getClientRotatedSecretExpirationTime())));
            return mapper.writeValueAsString(map);
        }
        catch (JsonProcessingException e) {
            return "";
        }
    }

    public ReadOnlyRotatedSecretClientModel toRotatedClientModel() throws InvalidObjectException {
        if (Objects.isNull(this.clientModel)) {
            throw new InvalidObjectException(this.getClass().getCanonicalName() + " does not have an attribute of type " + ClientModel.class.getCanonicalName());
        }
        return new ReadOnlyRotatedSecretClientModel();
    }

    public class ReadOnlyRotatedSecretClientModel
    extends ClientModelLazyDelegate {
        private ReadOnlyRotatedSecretClientModel() {
            super(() -> org$keycloak$protocol$oidc$OIDCClientSecretConfigWrapper$this.clientModel);
        }

        public String getSecret() {
            return OIDCClientSecretConfigWrapper.this.getClientRotatedSecret();
        }
    }
}

