/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml.installation;

import java.net.URI;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.keycloak.Config;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.ClientInstallationProvider;
import org.keycloak.protocol.saml.SamlClient;
import org.keycloak.protocol.util.ClientCliInstallationUtil;
import org.keycloak.services.resources.RealmsResource;

public class KeycloakSamlSubsystemCliInstallation
implements ClientInstallationProvider {
    public Response generateInstallation(KeycloakSession session, RealmModel realm, ClientModel client, URI baseUri) {
        SamlClient samlClient = new SamlClient(client);
        StringBuilder builder = new StringBuilder();
        String entityId = client.getBaseUrl() == null ? "SPECIFY YOUR entityID!" : client.getBaseUrl();
        String bindingUrl = RealmsResource.protocolUrl(UriBuilder.fromUri((URI)baseUri)).build(new Object[]{realm.getName(), "saml"}).toString();
        builder.append("/subsystem=keycloak-saml/secure-deployment=YOUR-WAR.war/:add\n\n").append("/subsystem=keycloak-saml/secure-deployment=YOUR-WAR.war/SP=").append(ClientCliInstallationUtil.quote(entityId)).append("/:add(sslPolicy=").append(realm.getSslRequired().name()).append(",logoutPage=").append(ClientCliInstallationUtil.quote("SPECIFY YOUR LOGOUT PAGE!")).append("\n\n");
        if (samlClient.requiresClientSignature()) {
            builder.append("/subsystem=keycloak-saml/secure-deployment=YOUR-WAR.war/SP=").append(ClientCliInstallationUtil.quote(entityId)).append("/Key=KEY1:add(signing=true, \\\nPrivateKeyPem=").append(ClientCliInstallationUtil.quote(samlClient.getClientSigningPrivateKey() == null ? "PRIVATE KEY NOT SET UP OR KNOWN" : samlClient.getClientSigningPrivateKey())).append(", \\\nCertificatePem=").append(ClientCliInstallationUtil.quote(samlClient.getClientSigningCertificate() == null ? "YOU MUST CONFIGURE YOUR_CLIENT's SIGNING CERTIFICATE" : samlClient.getClientSigningCertificate())).append(")\n\n");
        }
        if (samlClient.requiresEncryption()) {
            builder.append("/subsystem=keycloak-saml/secure-deployment=YOUR-WAR.war/SP=").append(ClientCliInstallationUtil.quote(entityId)).append("/Key=KEY2:add(encryption=true,PrivateKeyPem=").append(ClientCliInstallationUtil.quote(samlClient.getClientEncryptingPrivateKey() == null ? "PRIVATE KEY NOT SET UP OR KNOWN" : samlClient.getClientEncryptingPrivateKey())).append(")\n\n");
        }
        builder.append("/subsystem=keycloak-saml/secure-deployment=YOUR-WAR.war/SP=").append(ClientCliInstallationUtil.quote(entityId)).append("/IDP=idp/:add( \\\n    SingleSignOnService={ \\\n        signRequest=").append(Boolean.toString(samlClient.requiresClientSignature())).append(", \\\n        validateResponseSignature=").append(Boolean.toString(samlClient.requiresRealmSignature())).append(", \\\n        validateAssertionSignature=").append(Boolean.toString(samlClient.requiresAssertionSignature())).append(", \\\n        requestBinding=POST, \\\n        bindingUrl=").append(bindingUrl).append("}, \\\n    SingleLogoutService={ \\\n        signRequest=").append(Boolean.toString(samlClient.requiresClientSignature())).append(", \\\n        signResponse=").append(Boolean.toString(samlClient.requiresClientSignature())).append(", \\\n        validateRequestSignature=").append(Boolean.toString(samlClient.requiresRealmSignature())).append(", \\\n        validateResponseSignature=").append(Boolean.toString(samlClient.requiresRealmSignature())).append(", \\\n        requestBinding=POST, \\\n        responseBinding=POST, \\\n        postBindingUrl=").append(bindingUrl).append(", \\\n        redirectBindingUrl=").append(bindingUrl).append("} \\\n)\n\n");
        if (samlClient.requiresClientSignature()) {
            builder.append("/subsystem=keycloak-saml/secure-deployment=YOUR-WAR.war/SP=").append(ClientCliInstallationUtil.quote(entityId)).append("/IDP=idp/:write-attribute(name=signatureAlgorithm,value=").append(samlClient.getSignatureAlgorithm()).append(")\n\n");
            if (samlClient.getCanonicalizationMethod() != null) {
                builder.append("/subsystem=keycloak-saml/secure-deployment=YOUR-WAR.war/SP=").append(ClientCliInstallationUtil.quote(entityId)).append("/IDP=idp/:write-attribute(name=signatureCanonicalizationMethod,value=").append(samlClient.getCanonicalizationMethod()).append(")\n");
            }
        }
        return Response.ok((Object)builder.toString(), (MediaType)MediaType.TEXT_PLAIN_TYPE).build();
    }

    public String getProtocol() {
        return "saml";
    }

    public String getDisplayType() {
        return "Keycloak SAML JBoss Subsystem CLI";
    }

    public String getHelpText() {
        return "CLI script you must edit and apply to your client app server. This type of configuration is useful when you can't or don't want to crack open your WAR file.";
    }

    public String getFilename() {
        return "keycloak-saml-subsystem.cli";
    }

    public String getMediaType() {
        return "text/plain";
    }

    public boolean isDownloadOnly() {
        return false;
    }

    public void close() {
    }

    public ClientInstallationProvider create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getId() {
        return "keycloak-saml-subsystem-cli";
    }
}

