/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.admin;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.admin.representation.ScopeRepresentation;
import org.keycloak.authorization.admin.util.Models;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.resources.admin.RealmAuth;

public class ScopeService {
    private final AuthorizationProvider authorization;
    private final RealmAuth auth;
    private ResourceServer resourceServer;

    public ScopeService(ResourceServer resourceServer, AuthorizationProvider authorization, RealmAuth auth) {
        this.resourceServer = resourceServer;
        this.authorization = authorization;
        this.auth = auth;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response create(ScopeRepresentation scope) {
        this.auth.requireManage();
        Scope model = Models.toModel(scope, this.resourceServer, this.authorization);
        scope.setId(model.getId());
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)scope).build();
    }

    @Path(value="{id}")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response update(@PathParam(value="id") String id, ScopeRepresentation scope) {
        this.auth.requireManage();
        scope.setId(id);
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        Scope model = storeFactory.getScopeStore().findById(scope.getId());
        if (model == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        model.setName(scope.getName());
        model.setIconUri(scope.getIconUri());
        return Response.noContent().build();
    }

    @Path(value="{id}")
    @DELETE
    public Response delete(@PathParam(value="id") String id) {
        this.auth.requireManage();
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        List resources = storeFactory.getResourceStore().findByScope(new String[]{id});
        if (!resources.isEmpty()) {
            return ErrorResponse.exists("Scopes can not be removed while associated with resources.");
        }
        Scope scope = storeFactory.getScopeStore().findById(id);
        PolicyStore policyStore = storeFactory.getPolicyStore();
        List policies = policyStore.findByScopeIds(Arrays.asList(scope.getId()), this.resourceServer.getId());
        for (Policy policyModel : policies) {
            if (policyModel.getScopes().size() == 1) {
                policyStore.delete(policyModel.getId());
                continue;
            }
            policyModel.removeScope(scope);
        }
        storeFactory.getScopeStore().delete(id);
        return Response.noContent().build();
    }

    @Path(value="{id}")
    @GET
    @Produces(value={"application/json"})
    public Response findById(@PathParam(value="id") String id) {
        this.auth.requireView();
        Scope model = this.authorization.getStoreFactory().getScopeStore().findById(id);
        if (model == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)Models.toRepresentation(model, this.authorization)).build();
    }

    @GET
    @Produces(value={"application/json"})
    public Response findAll() {
        this.auth.requireView();
        return Response.ok(this.authorization.getStoreFactory().getScopeStore().findByResourceServer(this.resourceServer.getId()).stream().map(scope -> Models.toRepresentation(scope, this.authorization)).collect(Collectors.toList())).build();
    }
}

