/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.Decision;
import org.keycloak.authorization.identity.Identity;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.permission.ResourcePermission;
import org.keycloak.authorization.policy.evaluation.Result;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.representations.authorization.Permission;

public final class Permissions {
    public static List<ResourcePermission> all(ResourceServer resourceServer, Identity identity, AuthorizationProvider authorization) {
        ArrayList<ResourcePermission> permissions = new ArrayList<ResourcePermission>();
        StoreFactory storeFactory = authorization.getStoreFactory();
        ResourceStore resourceStore = storeFactory.getResourceStore();
        resourceStore.findByOwner(resourceServer.getClientId()).stream().forEach(resource -> permissions.addAll(Permissions.createResourcePermissions(resource)));
        resourceStore.findByOwner(identity.getId()).stream().forEach(resource -> permissions.addAll(Permissions.createResourcePermissions(resource)));
        return permissions;
    }

    public static List<ResourcePermission> createResourcePermissions(Resource resource) {
        ArrayList<ResourcePermission> permissions = new ArrayList<ResourcePermission>();
        List scopes = resource.getScopes();
        permissions.add(new ResourcePermission(resource, Collections.emptyList(), resource.getResourceServer()));
        for (Scope scope : scopes) {
            permissions.add(new ResourcePermission(resource, Arrays.asList(scope), resource.getResourceServer()));
        }
        return permissions;
    }

    public static List<Permission> allPermits(List<Result> evaluation) {
        List<Permission> permissions = evaluation.stream().filter(evaluationResult -> evaluationResult.getEffect().equals((Object)Decision.Effect.PERMIT)).map(evaluationResult -> {
            ResourcePermission permission = evaluationResult.getPermission();
            String resourceId = null;
            String resourceName = null;
            Resource resource = permission.getResource();
            if (resource != null) {
                resourceId = resource.getId();
                resourceName = resource.getName();
            }
            Set scopes = null;
            if (!permission.getScopes().isEmpty()) {
                scopes = permission.getScopes().stream().map(Scope::getName).collect(Collectors.toSet());
            }
            return new Permission(resourceId, resourceName, scopes);
        }).collect(Collectors.toList());
        HashMap perms = new HashMap();
        permissions.forEach(permission -> {
            Set permissionScopes;
            Permission evalPermission = (Permission)perms.get(permission.getResourceSetId());
            if (evalPermission == null) {
                evalPermission = permission;
                if (evalPermission.getScopes() != null && evalPermission.getScopes().isEmpty()) {
                    evalPermission.setScopes(null);
                }
                perms.put(permission.getResourceSetId(), evalPermission);
            }
            if ((permissionScopes = permission.getScopes()) != null && !permissionScopes.isEmpty()) {
                HashSet<String> scopes = evalPermission.getScopes();
                if (scopes == null) {
                    scopes = new HashSet<String>();
                    evalPermission.setScopes(scopes);
                }
                for (String scopeName : permissionScopes) {
                    if (scopes.contains(scopeName)) continue;
                    scopes.add(scopeName);
                }
            }
        });
        return perms.values().stream().collect(Collectors.toList());
    }
}

