/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.installation;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.keycloak.Config;
import org.keycloak.authentication.ClientAuthenticator;
import org.keycloak.authentication.ClientAuthenticatorFactory;
import org.keycloak.authorization.admin.AuthorizationService;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.protocol.ClientInstallationProvider;
import org.keycloak.representations.adapters.config.PolicyEnforcerConfig;
import org.keycloak.services.managers.ClientManager;
import org.keycloak.util.JsonSerialization;

public class KeycloakOIDCClientInstallation
implements ClientInstallationProvider {
    public Response generateInstallation(KeycloakSession session, RealmModel realm, ClientModel client, URI baseUri) {
        ClientManager.InstallationAdapterConfig rep = new ClientManager.InstallationAdapterConfig();
        rep.setAuthServerUrl(baseUri.toString());
        rep.setRealm(realm.getName());
        rep.setRealmKey(realm.getPublicKeyPem());
        rep.setSslRequired(realm.getSslRequired().name().toLowerCase());
        if (client.isPublicClient() && !client.isBearerOnly()) {
            rep.setPublicClient(true);
        }
        if (client.isBearerOnly()) {
            rep.setBearerOnly(true);
        }
        if (client.getRoles().size() > 0) {
            rep.setUseResourceRoleMappings(true);
        }
        rep.setResource(client.getClientId());
        if (KeycloakOIDCClientInstallation.showClientCredentialsAdapterConfig(client)) {
            Map<String, Object> adapterConfig = KeycloakOIDCClientInstallation.getClientCredentialsAdapterConfig(session, client);
            rep.setCredentials(adapterConfig);
        }
        this.configureAuthorizationSettings(session, client, rep);
        String json = null;
        try {
            json = JsonSerialization.writeValueAsPrettyString((Object)((Object)rep));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return Response.ok((Object)json, (MediaType)MediaType.TEXT_PLAIN_TYPE).build();
    }

    public static Map<String, Object> getClientCredentialsAdapterConfig(KeycloakSession session, ClientModel client) {
        String clientAuthenticator = client.getClientAuthenticatorType();
        ClientAuthenticatorFactory authenticator = (ClientAuthenticatorFactory)session.getKeycloakSessionFactory().getProviderFactory(ClientAuthenticator.class, clientAuthenticator);
        return authenticator.getAdapterConfiguration(client);
    }

    public static boolean showClientCredentialsAdapterConfig(ClientModel client) {
        if (client.isPublicClient()) {
            return false;
        }
        return !client.isBearerOnly() || client.getNodeReRegistrationTimeout() > 0;
    }

    public String getProtocol() {
        return "openid-connect";
    }

    public String getDisplayType() {
        return "Keycloak OIDC JSON";
    }

    public String getHelpText() {
        return "keycloak.json file used by the Keycloak OIDC client adapter to configure clients.  This must be saved to a keycloak.json file and put in your WEB-INF directory of your WAR file.  You may also want to tweak this file after you download it.";
    }

    public void close() {
    }

    public ClientInstallationProvider create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getId() {
        return "keycloak-oidc-keycloak-json";
    }

    public boolean isDownloadOnly() {
        return false;
    }

    public String getFilename() {
        return "keycloak.json";
    }

    public String getMediaType() {
        return "application/json";
    }

    private void configureAuthorizationSettings(KeycloakSession session, ClientModel client, ClientManager.InstallationAdapterConfig rep) {
        if (new AuthorizationService(session, client, null).isEnabled()) {
            PolicyEnforcerConfig enforcerConfig = new PolicyEnforcerConfig();
            enforcerConfig.setEnforcementMode(null);
            enforcerConfig.setPaths(null);
            rep.setEnforcerConfig(enforcerConfig);
            Set clientRoles = client.getRoles();
            if (clientRoles.size() == 1 && ((RoleModel)clientRoles.iterator().next()).getName().equals("uma_protection")) {
                rep.setUseResourceRoleMappings(null);
            }
        }
    }
}

