/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.mappers;

import java.util.ArrayDeque;
import java.util.LinkedHashSet;
import java.util.Set;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.oidc.mappers.AbstractOIDCProtocolMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAccessTokenMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAttributeMapperHelper;
import org.keycloak.protocol.oidc.mappers.OIDCIDTokenMapper;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.IDToken;

abstract class AbstractUserRoleMappingMapper
extends AbstractOIDCProtocolMapper
implements OIDCAccessTokenMapper,
OIDCIDTokenMapper {
    AbstractUserRoleMappingMapper() {
    }

    @Override
    public AccessToken transformAccessToken(AccessToken token, ProtocolMapperModel mappingModel, KeycloakSession session, UserSessionModel userSession, ClientSessionModel clientSession) {
        if (!OIDCAttributeMapperHelper.includeInAccessToken(mappingModel)) {
            return token;
        }
        this.setClaim((IDToken)token, mappingModel, userSession);
        return token;
    }

    @Override
    public IDToken transformIDToken(IDToken token, ProtocolMapperModel mappingModel, KeycloakSession session, UserSessionModel userSession, ClientSessionModel clientSession) {
        if (!OIDCAttributeMapperHelper.includeInIDToken(mappingModel)) {
            return token;
        }
        this.setClaim(token, mappingModel, userSession);
        return token;
    }

    protected abstract void setClaim(IDToken var1, ProtocolMapperModel var2, UserSessionModel var3);

    protected Set<String> flattenRoleModelToRoleNames(Set<RoleModel> roleModels, String prefix) {
        LinkedHashSet<String> roleNames = new LinkedHashSet<String>();
        ArrayDeque<RoleModel> stack = new ArrayDeque<RoleModel>(roleModels);
        while (!stack.isEmpty()) {
            RoleModel current = (RoleModel)stack.pop();
            if (current.isComposite()) {
                for (RoleModel compositeRoleModel : current.getComposites()) {
                    stack.push(compositeRoleModel);
                }
            }
            String roleName = current.getName();
            if (prefix != null && !prefix.trim().isEmpty()) {
                roleName = prefix.trim() + roleName;
            }
            roleNames.add(roleName);
        }
        return roleNames;
    }
}

