/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import jakarta.ws.rs.core.UriInfo;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.common.util.ServerCookie;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakUriInfo;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.RestartLoginCookie;
import org.keycloak.services.managers.AuthSessionId;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.util.CookieHelper;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.RootAuthenticationSessionModel;
import org.keycloak.sessions.StickySessionEncoderProvider;
import org.keycloak.utils.LockObjectsForModification;

public class AuthenticationSessionManager {
    public static final String AUTH_SESSION_ID = "AUTH_SESSION_ID";
    public static final int AUTH_SESSION_COOKIE_LIMIT = 3;
    private static final Logger log = Logger.getLogger(AuthenticationSessionManager.class);
    private final KeycloakSession session;

    public AuthenticationSessionManager(KeycloakSession session) {
        this.session = session;
    }

    public RootAuthenticationSessionModel createAuthenticationSession(RealmModel realm, boolean browserCookie) {
        RootAuthenticationSessionModel rootAuthSession = this.session.authenticationSessions().createRootAuthenticationSession(realm);
        if (browserCookie) {
            this.setAuthSessionCookie(rootAuthSession.getId(), realm);
        }
        return rootAuthSession;
    }

    public RootAuthenticationSessionModel getCurrentRootAuthenticationSession(RealmModel realm) {
        List<String> authSessionCookies = this.getAuthSessionCookies(realm);
        return authSessionCookies.stream().map(oldEncodedId -> {
            AuthSessionId authSessionId = this.decodeAuthSessionId((String)oldEncodedId);
            String sessionId = authSessionId.getDecodedId();
            RootAuthenticationSessionModel rootAuthSession = this.session.authenticationSessions().getRootAuthenticationSession(realm, sessionId);
            if (rootAuthSession != null) {
                this.reencodeAuthSessionCookie((String)oldEncodedId, authSessionId, realm);
                return rootAuthSession;
            }
            return null;
        }).filter(authSession -> Objects.nonNull(authSession)).findFirst().orElse(null);
    }

    public UserSessionModel getUserSessionFromAuthCookie(RealmModel realm) {
        List<String> authSessionCookies = this.getAuthSessionCookies(realm);
        return authSessionCookies.stream().map(oldEncodedId -> {
            AuthSessionId authSessionId = this.decodeAuthSessionId((String)oldEncodedId);
            String sessionId = authSessionId.getDecodedId();
            UserSessionModel userSession = (UserSessionModel)LockObjectsForModification.lockUserSessionsForModification((KeycloakSession)this.session, () -> this.session.sessions().getUserSession(realm, sessionId));
            if (userSession != null) {
                this.reencodeAuthSessionCookie((String)oldEncodedId, authSessionId, realm);
                return userSession;
            }
            return null;
        }).filter(authSession -> Objects.nonNull(authSession)).findFirst().orElse(null);
    }

    public AuthenticationSessionModel getCurrentAuthenticationSession(RealmModel realm, ClientModel client, String tabId) {
        List<String> authSessionCookies = this.getAuthSessionCookies(realm);
        return authSessionCookies.stream().map(oldEncodedId -> {
            AuthSessionId authSessionId = this.decodeAuthSessionId((String)oldEncodedId);
            String sessionId = authSessionId.getDecodedId();
            AuthenticationSessionModel authSession = this.getAuthenticationSessionByIdAndClient(realm, sessionId, client, tabId);
            if (authSession != null) {
                this.reencodeAuthSessionCookie((String)oldEncodedId, authSessionId, realm);
                return authSession;
            }
            return null;
        }).filter(authSession -> Objects.nonNull(authSession)).findFirst().orElse(null);
    }

    public void setAuthSessionCookie(String authSessionId, RealmModel realm) {
        KeycloakUriInfo uriInfo = this.session.getContext().getUri();
        String cookiePath = AuthenticationManager.getRealmCookiePath(realm, (UriInfo)uriInfo);
        boolean sslRequired = realm.getSslRequired().isRequired(this.session.getContext().getConnection());
        StickySessionEncoderProvider encoder = (StickySessionEncoderProvider)this.session.getProvider(StickySessionEncoderProvider.class);
        String encodedAuthSessionId = encoder.encodeSessionId(authSessionId);
        CookieHelper.addCookie(AUTH_SESSION_ID, encodedAuthSessionId, cookiePath, null, null, -1, sslRequired, true, ServerCookie.SameSiteAttributeValue.NONE, this.session);
        log.debugf("Set AUTH_SESSION_ID cookie with value %s", (Object)encodedAuthSessionId);
    }

    AuthSessionId decodeAuthSessionId(String encodedAuthSessionId) {
        log.debugf("Found AUTH_SESSION_ID cookie with value %s", (Object)encodedAuthSessionId);
        StickySessionEncoderProvider encoder = (StickySessionEncoderProvider)this.session.getProvider(StickySessionEncoderProvider.class);
        String decodedAuthSessionId = encoder.decodeSessionId(encodedAuthSessionId);
        String reencoded = encoder.encodeSessionId(decodedAuthSessionId);
        return new AuthSessionId(decodedAuthSessionId, reencoded);
    }

    void reencodeAuthSessionCookie(String oldEncodedAuthSessionId, AuthSessionId newAuthSessionId, RealmModel realm) {
        if (!oldEncodedAuthSessionId.equals(newAuthSessionId.getEncodedId())) {
            log.debugf("Route changed. Will update authentication session cookie. Old: '%s', New: '%s'", (Object)oldEncodedAuthSessionId, (Object)newAuthSessionId.getEncodedId());
            this.setAuthSessionCookie(newAuthSessionId.getDecodedId(), realm);
        }
    }

    List<String> getAuthSessionCookies(final RealmModel realm) {
        List authSessionIds;
        Set<String> cookiesVal = CookieHelper.getCookieValue(this.session, AUTH_SESSION_ID);
        if (cookiesVal.size() > 1) {
            AuthenticationManager.expireOldAuthSessionCookie(realm, (UriInfo)this.session.getContext().getUri(), this.session);
        }
        if ((authSessionIds = cookiesVal.stream().limit(3L).collect(Collectors.toList())).isEmpty()) {
            log.debugf("Not found AUTH_SESSION_ID cookie", new Object[0]);
        }
        return authSessionIds.stream().filter(new Predicate<String>(){

            @Override
            public boolean test(String id) {
                StickySessionEncoderProvider encoder = (StickySessionEncoderProvider)AuthenticationSessionManager.this.session.getProvider(StickySessionEncoderProvider.class);
                String decodedId = encoder.decodeSessionId(id);
                return AuthenticationSessionManager.this.session.authenticationSessions().getRootAuthenticationSession(realm, decodedId) != null;
            }
        }).collect(Collectors.toList());
    }

    public void removeAuthenticationSession(RealmModel realm, AuthenticationSessionModel authSession, boolean expireRestartCookie) {
        RootAuthenticationSessionModel rootAuthSession = authSession.getParentSession();
        log.debugf("Removing authSession '%s'. Expire restart cookie: %b", (Object)rootAuthSession.getId(), (Object)expireRestartCookie);
        this.session.authenticationSessions().removeRootAuthenticationSession(realm, rootAuthSession);
        if (expireRestartCookie) {
            KeycloakUriInfo uriInfo = this.session.getContext().getUri();
            RestartLoginCookie.expireRestartCookie(realm, (UriInfo)uriInfo, this.session);
            ((LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class)).setDetachedAuthSession();
        }
    }

    public void removeTabIdInAuthenticationSession(RealmModel realm, AuthenticationSessionModel authSession) {
        RootAuthenticationSessionModel rootAuthSession = authSession.getParentSession();
        rootAuthSession.removeAuthenticationSessionByTabId(authSession.getTabId());
        if (rootAuthSession.getAuthenticationSessions().isEmpty()) {
            this.removeAuthenticationSession(realm, authSession, false);
        }
    }

    public UserSessionModel getUserSession(AuthenticationSessionModel authSession) {
        return (UserSessionModel)LockObjectsForModification.lockUserSessionsForModification((KeycloakSession)this.session, () -> this.session.sessions().getUserSession(authSession.getRealm(), authSession.getParentSession().getId()));
    }

    public AuthenticationSessionModel getAuthenticationSessionByIdAndClient(RealmModel realm, String authSessionId, ClientModel client, String tabId) {
        RootAuthenticationSessionModel rootAuthSession = this.session.authenticationSessions().getRootAuthenticationSession(realm, authSessionId);
        return rootAuthSession == null ? null : rootAuthSession.getAuthenticationSession(client, tabId);
    }
}

