/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jboss.logging.Logger;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.services.managers.AuthSessionId;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.AuthenticationSessionManager;
import org.keycloak.utils.LockObjectsForModification;

public class UserSessionCrossDCManager {
    private static final Logger logger = Logger.getLogger(UserSessionCrossDCManager.class);
    private final KeycloakSession kcSession;

    public UserSessionCrossDCManager(KeycloakSession session) {
        this.kcSession = session;
    }

    public UserSessionModel getUserSessionWithClient(RealmModel realm, String id, boolean offline, String clientUUID) {
        return this.kcSession.sessions().getUserSessionWithPredicate(realm, id, offline, userSession -> userSession.getAuthenticatedClientSessionByClient(clientUUID) != null);
    }

    public UserSessionModel getUserSessionWithClient(RealmModel realm, String id, String clientUUID) {
        return this.kcSession.sessions().getUserSessionWithPredicate(realm, id, false, userSession -> {
            AuthenticatedClientSessionModel authSessions = userSession.getAuthenticatedClientSessionByClient(clientUUID);
            return authSessions != null;
        });
    }

    public UserSessionModel getUserSessionIfExistsRemotely(AuthenticationSessionManager asm, RealmModel realm) {
        AuthenticationManager.AuthResult authResult;
        List<String> sessionCookies = asm.getAuthSessionCookies(realm);
        if (sessionCookies.isEmpty() && (authResult = (AuthenticationManager.AuthResult)LockObjectsForModification.lockUserSessionsForModification((KeycloakSession)this.kcSession, () -> AuthenticationManager.authenticateIdentityCookie(this.kcSession, realm, true))) != null && authResult.getSession() != null) {
            sessionCookies = Collections.singletonList(authResult.getSession().getId());
        }
        return sessionCookies.stream().map(oldEncodedId -> {
            AuthSessionId authSessionId = asm.decodeAuthSessionId((String)oldEncodedId);
            String sessionId = authSessionId.getDecodedId();
            LockObjectsForModification.lockUserSessionsForModification((KeycloakSession)this.kcSession, () -> this.kcSession.sessions().getUserSessionWithPredicate(realm, sessionId, false, userSession2 -> userSession2 == null));
            UserSessionModel userSession = (UserSessionModel)LockObjectsForModification.lockUserSessionsForModification((KeycloakSession)this.kcSession, () -> this.kcSession.sessions().getUserSession(realm, sessionId));
            if (userSession != null) {
                asm.reencodeAuthSessionCookie((String)oldEncodedId, authSessionId, realm);
                return userSession;
            }
            return null;
        }).filter(userSession -> Objects.nonNull(userSession)).findFirst().orElse(null);
    }
}

