/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.requiredactions;

import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import org.keycloak.Config;
import org.keycloak.authentication.RequiredActionContext;
import org.keycloak.authentication.RequiredActionFactory;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.common.util.Time;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.UserModel;

public class TermsAndConditions
implements RequiredActionProvider,
RequiredActionFactory {
    public static final String PROVIDER_ID = UserModel.RequiredAction.TERMS_AND_CONDITIONS.name();
    public static final String USER_ATTRIBUTE = "terms_and_conditions";

    public RequiredActionProvider create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public void evaluateTriggers(RequiredActionContext context) {
    }

    public void requiredActionChallenge(RequiredActionContext context) {
        Response challenge = context.form().setAttribute("user", (Object)context.getAuthenticationSession().getAuthenticatedUser()).createForm("terms.ftl");
        context.challenge(challenge);
    }

    public void processAction(RequiredActionContext context) {
        context.getUser().removeAttribute(USER_ATTRIBUTE.toUpperCase());
        if (context.getHttpRequest().getDecodedFormParameters().containsKey((Object)"cancel")) {
            context.getUser().removeAttribute(USER_ATTRIBUTE);
            context.failure();
            return;
        }
        context.getUser().setAttribute(USER_ATTRIBUTE, Arrays.asList(Integer.toString(Time.currentTime())));
        context.success();
    }

    public String getDisplayText() {
        return "Terms and Conditions";
    }

    public void close() {
    }
}

