/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.account;

import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.resteasy.reactive.NoCache;
import org.keycloak.device.DeviceActivityManager;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.representations.account.ClientRepresentation;
import org.keycloak.representations.account.DeviceRepresentation;
import org.keycloak.representations.account.SessionRepresentation;
import org.keycloak.services.managers.Auth;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.utils.LockObjectsForModification;

public class SessionResource {
    private final KeycloakSession session;
    private final Auth auth;
    private final RealmModel realm;
    private final UserModel user;

    public SessionResource(KeycloakSession session, Auth auth) {
        this.session = session;
        this.auth = auth;
        this.realm = auth.getRealm();
        this.user = auth.getUser();
    }

    @GET
    @Produces(value={"application/json"})
    @NoCache
    public Stream<SessionRepresentation> toRepresentation() {
        return this.session.sessions().getUserSessionsStream(this.realm, this.user).map(this::toRepresentation);
    }

    @Path(value="devices")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public Collection<DeviceRepresentation> devices() {
        HashMap reps = new HashMap();
        this.session.sessions().getUserSessionsStream(this.realm, this.user).forEach(s -> {
            DeviceRepresentation device = this.getAttachedDevice((UserSessionModel)s);
            DeviceRepresentation rep = reps.computeIfAbsent(device.getOs() + device.getOsVersion(), key -> {
                DeviceRepresentation representation = new DeviceRepresentation();
                representation.setLastAccess(device.getLastAccess());
                representation.setOs(device.getOs());
                representation.setOsVersion(device.getOsVersion());
                representation.setDevice(device.getDevice());
                representation.setMobile(device.isMobile());
                return representation;
            });
            if (this.isCurrentSession((UserSessionModel)s)) {
                rep.setCurrent(Boolean.valueOf(true));
            }
            if (rep.getLastAccess() == 0 || rep.getLastAccess() < s.getLastSessionRefresh()) {
                rep.setLastAccess(s.getLastSessionRefresh());
            }
            rep.addSession(this.createSessionRepresentation((UserSessionModel)s, device));
        });
        return reps.values();
    }

    @DELETE
    @Produces(value={"application/json"})
    @NoCache
    public Response logout(@QueryParam(value="current") boolean removeCurrent) {
        this.auth.require("manage-account");
        this.session.sessions().getUserSessionsStream(this.realm, this.user).filter(s -> removeCurrent || !this.isCurrentSession((UserSessionModel)s)).collect(Collectors.toList()).forEach(s -> AuthenticationManager.backchannelLogout(this.session, s, true));
        return Response.noContent().build();
    }

    @Path(value="/{id}")
    @DELETE
    @Produces(value={"application/json"})
    @NoCache
    public Response logout(@PathParam(value="id") String id) {
        this.auth.require("manage-account");
        UserSessionModel userSession = (UserSessionModel)LockObjectsForModification.lockUserSessionsForModification((KeycloakSession)this.session, () -> this.session.sessions().getUserSession(this.realm, id));
        if (userSession != null && userSession.getUser().equals(this.user)) {
            AuthenticationManager.backchannelLogout(this.session, userSession, true);
        }
        return Response.noContent().build();
    }

    private SessionRepresentation createSessionRepresentation(UserSessionModel s, DeviceRepresentation device) {
        SessionRepresentation sessionRep = new SessionRepresentation();
        sessionRep.setId(s.getId());
        sessionRep.setIpAddress(s.getIpAddress());
        sessionRep.setStarted(s.getStarted());
        sessionRep.setLastAccess(s.getLastSessionRefresh());
        int maxLifespan = s.isRememberMe() && this.realm.getSsoSessionMaxLifespanRememberMe() > 0 ? this.realm.getSsoSessionMaxLifespanRememberMe() : this.realm.getSsoSessionMaxLifespan();
        int expires = s.getStarted() + maxLifespan;
        sessionRep.setExpires(expires);
        sessionRep.setBrowser(device.getBrowser());
        if (this.isCurrentSession(s)) {
            sessionRep.setCurrent(Boolean.valueOf(true));
        }
        sessionRep.setClients(new LinkedList());
        for (String clientUUID : s.getAuthenticatedClientSessions().keySet()) {
            ClientModel client = this.realm.getClientById(clientUUID);
            ClientRepresentation clientRep = new ClientRepresentation();
            clientRep.setClientId(client.getClientId());
            clientRep.setClientName(client.getName());
            sessionRep.getClients().add(clientRep);
        }
        return sessionRep;
    }

    private DeviceRepresentation getAttachedDevice(UserSessionModel s) {
        DeviceRepresentation device = DeviceActivityManager.getCurrentDevice((UserSessionModel)s);
        if (device == null) {
            device = DeviceRepresentation.unknown();
            device.setIpAddress(s.getIpAddress());
        }
        return device;
    }

    private boolean isCurrentSession(UserSessionModel session) {
        if (this.auth.getSession() == null) {
            return false;
        }
        return session.getId().equals(this.auth.getSession().getId());
    }

    private SessionRepresentation toRepresentation(UserSessionModel s) {
        return this.createSessionRepresentation(s, this.getAttachedDevice(s));
    }
}

