/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.extensions.Extension;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.jboss.resteasy.reactive.NoCache;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.ScopeContainerModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;

@Extension(name="x-smallrye-profile-admin", value="")
public class ScopeMappedClientResource {
    protected RealmModel realm;
    protected AdminPermissionEvaluator auth;
    protected AdminPermissionEvaluator.RequirePermissionCheck managePermission;
    protected AdminPermissionEvaluator.RequirePermissionCheck viewPermission;
    protected ScopeContainerModel scopeContainer;
    protected KeycloakSession session;
    protected ClientModel scopedClient;
    protected AdminEventBuilder adminEvent;

    public ScopeMappedClientResource(RealmModel realm, AdminPermissionEvaluator auth, ScopeContainerModel scopeContainer, KeycloakSession session, ClientModel scopedClient, AdminEventBuilder adminEvent, AdminPermissionEvaluator.RequirePermissionCheck managePermission, AdminPermissionEvaluator.RequirePermissionCheck viewPermission) {
        this.realm = realm;
        this.auth = auth;
        this.scopeContainer = scopeContainer;
        this.session = session;
        this.scopedClient = scopedClient;
        this.adminEvent = adminEvent.resource(ResourceType.CLIENT_SCOPE_MAPPING);
        this.managePermission = managePermission;
        this.viewPermission = viewPermission;
    }

    @GET
    @Produces(value={"application/json"})
    @NoCache
    @Tag(name="Scope Mappings")
    @Operation(summary="Get the roles associated with a client's scope Returns roles for the client.")
    public Stream<RoleRepresentation> getClientScopeMappings() {
        this.viewPermission.require();
        return KeycloakModelUtils.getClientScopeMappingsStream((ClientModel)this.scopedClient, (ScopeContainerModel)this.scopeContainer).map(ModelToRepresentation::toBriefRepresentation);
    }

    @Path(value="available")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    @Tag(name="Scope Mappings")
    @Operation(summary="The available client-level roles Returns the roles for the client that can be associated with the client's scope")
    public Stream<RoleRepresentation> getAvailableClientScopeMappings() {
        this.viewPermission.require();
        return this.scopedClient.getRolesStream().filter(((Predicate<RoleModel>)arg_0 -> ((ScopeContainerModel)this.scopeContainer).hasDirectScope(arg_0)).negate()).filter(this.auth.roles()::canMapClientScope).map(ModelToRepresentation::toBriefRepresentation);
    }

    @Path(value="composite")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    @Tag(name="Scope Mappings")
    @Operation(summary="Get effective client roles Returns the roles for the client that are associated with the client's scope.")
    public Stream<RoleRepresentation> getCompositeClientScopeMappings(@Parameter(description="if false, return roles with their attributes") @QueryParam(value="briefRepresentation") @DefaultValue(value="true") boolean briefRepresentation) {
        this.viewPermission.require();
        Function<RoleModel, RoleRepresentation> toBriefRepresentation = briefRepresentation ? ModelToRepresentation::toBriefRepresentation : ModelToRepresentation::toRepresentation;
        return this.scopedClient.getRolesStream().filter(arg_0 -> ((ScopeContainerModel)this.scopeContainer).hasScope(arg_0)).map(toBriefRepresentation);
    }

    @POST
    @Consumes(value={"application/json"})
    @Tag(name="Scope Mappings")
    @Operation(summary="Add client-level roles to the client's scope")
    public void addClientScopeMapping(List<RoleRepresentation> roles) {
        this.managePermission.require();
        for (RoleRepresentation role : roles) {
            RoleModel roleModel = this.scopedClient.getRole(role.getName());
            if (roleModel == null) {
                throw new NotFoundException("Role not found");
            }
            this.scopeContainer.addScopeMapping(roleModel);
        }
        this.adminEvent.operation(OperationType.CREATE).resourcePath((UriInfo)this.session.getContext().getUri()).representation(roles).success();
    }

    @DELETE
    @Consumes(value={"application/json"})
    @Tag(name="Scope Mappings")
    @Operation(summary="Remove client-level roles from the client's scope.")
    public void deleteClientScopeMapping(List<RoleRepresentation> roles) {
        this.managePermission.require();
        if (roles == null) {
            roles = KeycloakModelUtils.getClientScopeMappingsStream((ClientModel)this.scopedClient, (ScopeContainerModel)this.scopeContainer).peek(arg_0 -> ((ScopeContainerModel)this.scopeContainer).deleteScopeMapping(arg_0)).map(ModelToRepresentation::toBriefRepresentation).collect(Collectors.toList());
        } else {
            for (RoleRepresentation role : roles) {
                RoleModel roleModel = this.scopedClient.getRole(role.getName());
                if (roleModel == null) {
                    throw new NotFoundException("Role not found");
                }
                this.scopeContainer.deleteScopeMapping(roleModel);
            }
        }
        this.adminEvent.operation(OperationType.DELETE).resourcePath((UriInfo)this.session.getContext().getUri()).representation(roles).success();
    }
}

