/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.conditional;

import java.util.List;
import org.keycloak.Config;
import org.keycloak.authentication.AuthenticationFlowCallbackFactory;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.authenticators.conditional.ConditionalAuthenticator;
import org.keycloak.authentication.authenticators.conditional.ConditionalAuthenticatorFactory;
import org.keycloak.authentication.authenticators.conditional.ConditionalLoaAuthenticator;
import org.keycloak.common.Profile;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;

public class ConditionalLoaAuthenticatorFactory
implements ConditionalAuthenticatorFactory,
AuthenticationFlowCallbackFactory,
EnvironmentDependentProviderFactory {
    public static final String PROVIDER_ID = "conditional-level-of-authentication";
    private static final AuthenticationExecutionModel.Requirement[] REQUIREMENT_CHOICES = new AuthenticationExecutionModel.Requirement[]{AuthenticationExecutionModel.Requirement.REQUIRED, AuthenticationExecutionModel.Requirement.DISABLED};
    private static final List<ProviderConfigProperty> CONFIG = ProviderConfigurationBuilder.create().property().name("loa-condition-level").label("loa-condition-level").helpText("loa-condition-level.tooltip").type("String").add().property().name("loa-max-age").label("loa-max-age").helpText("loa-max-age.tooltip").type("String").defaultValue((Object)36000).add().build();

    @Override
    public Authenticator create(KeycloakSession session) {
        return new ConditionalLoaAuthenticator(session);
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getDisplayType() {
        return "Condition - Level of Authentication";
    }

    public boolean isConfigurable() {
        return true;
    }

    public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
        return REQUIREMENT_CHOICES;
    }

    public boolean isUserSetupAllowed() {
        return false;
    }

    public String getHelpText() {
        return "Flow is executed only if the configured LOA or a higher one has been requested but not yet satisfied. After the flow is successfully finished, the LOA in the session will be updated to value prescribed by this condition.";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return CONFIG;
    }

    @Override
    public ConditionalAuthenticator getSingleton() {
        return null;
    }

    public boolean isSupported() {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.STEP_UP_AUTHENTICATION);
    }
}

