/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.forms.login.freemarker;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Encode;
import org.keycloak.cookie.CookieProvider;
import org.keycloak.cookie.CookieType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.sessions.RootAuthenticationSessionModel;
import org.keycloak.util.JsonSerialization;

public class AuthenticationStateCookie {
    private static final Logger logger = Logger.getLogger(AuthenticationStateCookie.class);
    public static final String KC_AUTH_STATE = "KC_AUTH_STATE";
    @JsonProperty(value="authSessionId")
    private String authSessionId;
    @JsonProperty(value="remainingTabs")
    private Set<String> remainingTabs;

    public String getAuthSessionId() {
        return this.authSessionId;
    }

    public void setAuthSessionId(String authSessionId) {
        this.authSessionId = authSessionId;
    }

    public Set<String> getRemainingTabs() {
        return this.remainingTabs;
    }

    public void setRemainingTabs(Set<String> remainingTabs) {
        this.remainingTabs = remainingTabs;
    }

    public static void generateAndSetCookie(KeycloakSession session, RootAuthenticationSessionModel rootAuthSession, int cookieMaxAge) {
        AuthenticationStateCookie cookie = new AuthenticationStateCookie();
        cookie.setAuthSessionId(rootAuthSession.getId());
        cookie.setRemainingTabs(rootAuthSession.getAuthenticationSessions().keySet());
        try {
            String encoded = Encode.urlEncode((String)JsonSerialization.writeValueAsString((Object)cookie));
            ((CookieProvider)session.getProvider(CookieProvider.class)).set(CookieType.AUTH_STATE, encoded, cookieMaxAge);
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Exception thrown when encoding cookie", ioe);
        }
    }

    public static void expireCookie(KeycloakSession session) {
        ((CookieProvider)session.getProvider(CookieProvider.class)).expire(CookieType.AUTH_STATE);
    }

    public String toString() {
        return "AuthenticationStateCookie [ " + ("authSessionId=" + this.authSessionId) + (", remainingTabs=" + this.remainingTabs) + " ]";
    }
}

