/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.email;

import jakarta.mail.Address;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.internet.MimeUtility;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.jboss.logging.Logger;
import org.keycloak.common.enums.HostnameVerificationPolicy;
import org.keycloak.email.EmailException;
import org.keycloak.email.EmailSenderProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserModel;
import org.keycloak.services.ServicesLogger;
import org.keycloak.truststore.JSSETruststoreConfigurator;
import org.keycloak.utils.StringUtil;
import org.keycloak.vault.VaultStringSecret;

public class DefaultEmailSenderProvider
implements EmailSenderProvider {
    private static final Logger logger = Logger.getLogger(DefaultEmailSenderProvider.class);
    private static final String SUPPORTED_SSL_PROTOCOLS = DefaultEmailSenderProvider.getSupportedSslProtocols();
    private final KeycloakSession session;

    public DefaultEmailSenderProvider(KeycloakSession session) {
        this.session = session;
    }

    public void send(Map<String, String> config, UserModel user, String subject, String textBody, String htmlBody) throws EmailException {
        this.send(config, this.retrieveEmailAddress(user), subject, textBody, htmlBody);
    }

    public void send(Map<String, String> config, String address, String subject, String textBody, String htmlBody) throws EmailException {
        Transport transport = null;
        try {
            Properties props = new Properties();
            if (config.containsKey("host")) {
                props.setProperty("mail.smtp.host", config.get("host"));
            }
            boolean auth = "true".equals(config.get("auth"));
            boolean ssl = "true".equals(config.get("ssl"));
            boolean starttls = "true".equals(config.get("starttls"));
            if (config.containsKey("port") && config.get("port") != null) {
                props.setProperty("mail.smtp.port", config.get("port"));
            }
            if (auth) {
                props.setProperty("mail.smtp.auth", "true");
            }
            if (ssl) {
                props.setProperty("mail.smtp.ssl.enable", "true");
            }
            if (starttls) {
                props.setProperty("mail.smtp.starttls.enable", "true");
            }
            if (ssl || starttls || auth) {
                props.put("mail.smtp.ssl.protocols", SUPPORTED_SSL_PROTOCOLS);
                this.setupTruststore(props);
            }
            props.setProperty("mail.smtp.timeout", "10000");
            props.setProperty("mail.smtp.connectiontimeout", "10000");
            String from = config.get("from");
            String fromDisplayName = config.get("fromDisplayName");
            String replyTo = config.get("replyTo");
            String replyToDisplayName = config.get("replyToDisplayName");
            String envelopeFrom = config.get("envelopeFrom");
            Session session = Session.getInstance((Properties)props);
            MimeMultipart multipart = new MimeMultipart("alternative");
            if (textBody != null) {
                MimeBodyPart textPart = new MimeBodyPart();
                textPart.setText(textBody, "UTF-8");
                multipart.addBodyPart((BodyPart)textPart);
            }
            if (htmlBody != null) {
                MimeBodyPart htmlPart = new MimeBodyPart();
                htmlPart.setContent((Object)htmlBody, "text/html; charset=UTF-8");
                multipart.addBodyPart((BodyPart)htmlPart);
            }
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom((Address)this.toInternetAddress(from, fromDisplayName));
            msg.setReplyTo(new Address[]{this.toInternetAddress(from, fromDisplayName)});
            if (StringUtil.isNotBlank((String)replyTo)) {
                msg.setReplyTo(new Address[]{this.toInternetAddress(replyTo, replyToDisplayName)});
            }
            if (StringUtil.isNotBlank((String)envelopeFrom)) {
                props.setProperty("mail.smtp.from", envelopeFrom);
            }
            msg.setHeader("To", address);
            msg.setSubject(MimeUtility.encodeText((String)subject, (String)StandardCharsets.UTF_8.name(), null));
            msg.setContent((Multipart)multipart);
            msg.saveChanges();
            msg.setSentDate(new Date());
            transport = session.getTransport("smtp");
            if (auth) {
                try (VaultStringSecret vaultStringSecret = this.session.vault().getStringSecret(config.get("password"));){
                    transport.connect(config.get("user"), vaultStringSecret.get().orElse(config.get("password")));
                }
            } else {
                transport.connect();
            }
            transport.sendMessage((Message)msg, (Address[])new InternetAddress[]{new InternetAddress(address)});
        }
        catch (Exception e) {
            ServicesLogger.LOGGER.failedToSendEmail(e);
            throw new EmailException((Throwable)e);
        }
        finally {
            if (transport != null) {
                try {
                    transport.close();
                }
                catch (MessagingException e) {
                    logger.warn((Object)"Failed to close transport", (Throwable)e);
                }
            }
        }
    }

    protected InternetAddress toInternetAddress(String email, String displayName) throws UnsupportedEncodingException, AddressException, EmailException {
        if (email == null || "".equals(email.trim())) {
            throw new EmailException("Please provide a valid address", null);
        }
        if (displayName == null || "".equals(displayName.trim())) {
            return new InternetAddress(email);
        }
        return new InternetAddress(email, displayName, "utf-8");
    }

    protected String retrieveEmailAddress(UserModel user) {
        return user.getEmail();
    }

    private void setupTruststore(Properties props) {
        JSSETruststoreConfigurator configurator = new JSSETruststoreConfigurator(this.session);
        SSLSocketFactory factory = configurator.getSSLSocketFactory();
        if (factory != null) {
            props.put("mail.smtp.ssl.socketFactory", factory);
            if (configurator.getProvider().getPolicy() == HostnameVerificationPolicy.ANY) {
                props.setProperty("mail.smtp.ssl.trust", "*");
                props.put("mail.smtp.ssl.checkserveridentity", Boolean.FALSE.toString());
            }
        }
    }

    public void close() {
    }

    private static String getSupportedSslProtocols() {
        try {
            CharSequence[] protocols = SSLContext.getDefault().getSupportedSSLParameters().getProtocols();
            if (protocols != null) {
                return String.join((CharSequence)" ", protocols);
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to get list of supported SSL protocols", (Throwable)e);
        }
        return null;
    }
}

