/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin.permissions;

import jakarta.ws.rs.ForbiddenException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.permission.ResourcePermission;
import org.keycloak.authorization.policy.evaluation.EvaluationContext;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.GroupModel;
import org.keycloak.representations.idm.authorization.Permission;
import org.keycloak.services.resources.admin.permissions.GroupPermissionEvaluator;
import org.keycloak.services.resources.admin.permissions.GroupPermissionManagement;
import org.keycloak.services.resources.admin.permissions.Helper;
import org.keycloak.services.resources.admin.permissions.MgmtPermissions;

class GroupPermissions
implements GroupPermissionEvaluator,
GroupPermissionManagement {
    private static final String MANAGE_MEMBERSHIP_SCOPE = "manage-membership";
    private static final String MANAGE_MEMBERS_SCOPE = "manage-members";
    private static final String VIEW_MEMBERS_SCOPE = "view-members";
    private static final String RESOURCE_NAME_PREFIX = "group.resource.";
    private final AuthorizationProvider authz;
    private final MgmtPermissions root;
    private final ResourceStore resourceStore;
    private final PolicyStore policyStore;

    GroupPermissions(AuthorizationProvider authz, MgmtPermissions root) {
        this.authz = authz;
        this.root = root;
        if (authz != null) {
            this.resourceStore = authz.getStoreFactory().getResourceStore();
            this.policyStore = authz.getStoreFactory().getPolicyStore();
        } else {
            this.resourceStore = null;
            this.policyStore = null;
        }
    }

    private static String getGroupResourceName(GroupModel group) {
        return RESOURCE_NAME_PREFIX + group.getId();
    }

    private static String getManagePermissionGroup(GroupModel group) {
        return "manage.permission.group." + group.getId();
    }

    private static String getManageMembersPermissionGroup(GroupModel group) {
        return "manage.members.permission.group." + group.getId();
    }

    private static String getManageMembershipPermissionGroup(GroupModel group) {
        return "manage.membership.permission.group." + group.getId();
    }

    private static String getViewPermissionGroup(GroupModel group) {
        return "view.permission.group." + group.getId();
    }

    private static String getViewMembersPermissionGroup(GroupModel group) {
        return "view.members.permission.group." + group.getId();
    }

    private void initialize(GroupModel group) {
        String manageMembershipPermissionName;
        Policy manageMembershipPermission;
        String viewMembersPermissionName;
        Policy viewMembersPermission;
        String manageMembersPermissionName;
        Policy manageMembersPermission;
        String viewPermissionName;
        Policy viewPermission;
        String managePermissionName;
        Policy managePermission;
        ResourceServer server = this.root.initializeRealmResourceServer();
        if (server == null) {
            return;
        }
        this.root.initializeRealmDefaultScopes();
        Scope manageScope = this.root.realmManageScope();
        Scope viewScope = this.root.realmViewScope();
        Scope manageMembersScope = this.root.initializeRealmScope(MANAGE_MEMBERS_SCOPE);
        Scope viewMembersScope = this.root.initializeRealmScope(VIEW_MEMBERS_SCOPE);
        Scope manageMembershipScope = this.root.initializeRealmScope(MANAGE_MEMBERSHIP_SCOPE);
        String groupResourceName = GroupPermissions.getGroupResourceName(group);
        Resource groupResource = this.resourceStore.findByName(server, groupResourceName);
        if (groupResource == null) {
            groupResource = this.resourceStore.create(server, groupResourceName, server.getClientId());
            HashSet<Scope> scopeset = new HashSet<Scope>();
            scopeset.add(manageScope);
            scopeset.add(viewScope);
            scopeset.add(viewMembersScope);
            scopeset.add(manageMembershipScope);
            scopeset.add(manageMembersScope);
            groupResource.updateScopes(scopeset);
            groupResource.setType("Group");
        }
        if ((managePermission = this.policyStore.findByName(server, managePermissionName = GroupPermissions.getManagePermissionGroup(group))) == null) {
            Helper.addEmptyScopePermission(this.authz, server, managePermissionName, groupResource, manageScope);
        }
        if ((viewPermission = this.policyStore.findByName(server, viewPermissionName = GroupPermissions.getViewPermissionGroup(group))) == null) {
            Helper.addEmptyScopePermission(this.authz, server, viewPermissionName, groupResource, viewScope);
        }
        if ((manageMembersPermission = this.policyStore.findByName(server, manageMembersPermissionName = GroupPermissions.getManageMembersPermissionGroup(group))) == null) {
            Helper.addEmptyScopePermission(this.authz, server, manageMembersPermissionName, groupResource, manageMembersScope);
        }
        if ((viewMembersPermission = this.policyStore.findByName(server, viewMembersPermissionName = GroupPermissions.getViewMembersPermissionGroup(group))) == null) {
            Helper.addEmptyScopePermission(this.authz, server, viewMembersPermissionName, groupResource, viewMembersScope);
        }
        if ((manageMembershipPermission = this.policyStore.findByName(server, manageMembershipPermissionName = GroupPermissions.getManageMembershipPermissionGroup(group))) == null) {
            Helper.addEmptyScopePermission(this.authz, server, manageMembershipPermissionName, groupResource, manageMembershipScope);
        }
    }

    @Override
    public boolean canList() {
        return this.canView() || this.root.hasOneAdminRole(AdminRoles.VIEW_USERS, AdminRoles.MANAGE_USERS, AdminRoles.QUERY_GROUPS);
    }

    @Override
    public void requireList() {
        if (!this.canList()) {
            throw new ForbiddenException();
        }
    }

    @Override
    public boolean isPermissionsEnabled(GroupModel group) {
        ResourceServer server = this.root.realmResourceServer();
        if (server == null) {
            return false;
        }
        return this.resourceStore.findByName(server, GroupPermissions.getGroupResourceName(group)) != null;
    }

    @Override
    public void setPermissionsEnabled(GroupModel group, boolean enable) {
        if (enable) {
            this.initialize(group);
        } else {
            this.deletePermissions(group);
        }
    }

    @Override
    public Policy viewMembersPermission(GroupModel group) {
        ResourceServer server = this.root.realmResourceServer();
        if (server == null) {
            return null;
        }
        return this.policyStore.findByName(server, GroupPermissions.getViewMembersPermissionGroup(group));
    }

    @Override
    public Policy manageMembersPermission(GroupModel group) {
        ResourceServer server = this.root.realmResourceServer();
        if (server == null) {
            return null;
        }
        return this.policyStore.findByName(server, GroupPermissions.getManageMembersPermissionGroup(group));
    }

    @Override
    public Policy manageMembershipPermission(GroupModel group) {
        ResourceServer server = this.root.realmResourceServer();
        if (server == null) {
            return null;
        }
        return this.policyStore.findByName(server, GroupPermissions.getManageMembershipPermissionGroup(group));
    }

    @Override
    public Policy viewPermission(GroupModel group) {
        ResourceServer server = this.root.realmResourceServer();
        if (server == null) {
            return null;
        }
        return this.policyStore.findByName(server, GroupPermissions.getViewPermissionGroup(group));
    }

    @Override
    public Policy managePermission(GroupModel group) {
        ResourceServer server = this.root.realmResourceServer();
        if (server == null) {
            return null;
        }
        return this.policyStore.findByName(server, GroupPermissions.getManagePermissionGroup(group));
    }

    @Override
    public Resource resource(GroupModel group) {
        ResourceServer server = this.root.realmResourceServer();
        if (server == null) {
            return null;
        }
        Resource resource = this.resourceStore.findByName(server, GroupPermissions.getGroupResourceName(group));
        if (resource == null) {
            return null;
        }
        return resource;
    }

    @Override
    public Map<String, String> getPermissions(GroupModel group) {
        if (this.authz == null) {
            return null;
        }
        this.initialize(group);
        LinkedHashMap<String, String> scopes = new LinkedHashMap<String, String>();
        scopes.put("view", this.viewPermission(group).getId());
        scopes.put("manage", this.managePermission(group).getId());
        scopes.put(VIEW_MEMBERS_SCOPE, this.viewMembersPermission(group).getId());
        scopes.put(MANAGE_MEMBERS_SCOPE, this.manageMembersPermission(group).getId());
        scopes.put(MANAGE_MEMBERSHIP_SCOPE, this.manageMembershipPermission(group).getId());
        return scopes;
    }

    @Override
    public boolean canManage(GroupModel group) {
        if (this.canManage()) {
            return true;
        }
        if (!this.root.isAdminSameRealm()) {
            return false;
        }
        return this.hasPermission(group, "manage");
    }

    @Override
    public void requireManage(GroupModel group) {
        if (!this.canManage(group)) {
            throw new ForbiddenException();
        }
    }

    @Override
    public boolean canView(GroupModel group) {
        if (this.canView() || this.canManage()) {
            return true;
        }
        if (!this.root.isAdminSameRealm()) {
            return false;
        }
        return this.hasPermission(group, "view", "manage");
    }

    @Override
    public void requireView(GroupModel group) {
        if (!this.canView(group)) {
            throw new ForbiddenException();
        }
    }

    @Override
    public boolean canManage() {
        return this.root.users().canManageDefault();
    }

    @Override
    public void requireManage() {
        if (!this.canManage()) {
            throw new ForbiddenException();
        }
    }

    @Override
    public boolean canView() {
        return this.root.users().canViewDefault();
    }

    @Override
    public void requireView() {
        if (!this.canView()) {
            throw new ForbiddenException();
        }
    }

    @Override
    public boolean getGroupsWithViewPermission(GroupModel group) {
        if (this.root.users().canView() || this.root.users().canManage()) {
            return true;
        }
        if (!this.root.isAdminSameRealm()) {
            return false;
        }
        ResourceServer server = this.root.realmResourceServer();
        if (server == null) {
            return false;
        }
        return this.hasPermission(group, VIEW_MEMBERS_SCOPE, MANAGE_MEMBERS_SCOPE);
    }

    @Override
    public Set<String> getGroupsWithViewPermission() {
        if (this.root.users().canView() || this.root.users().canManage()) {
            return Collections.emptySet();
        }
        if (!this.root.isAdminSameRealm()) {
            return Collections.emptySet();
        }
        ResourceServer server = this.root.realmResourceServer();
        if (server == null) {
            return Collections.emptySet();
        }
        HashSet<String> granted = new HashSet<String>();
        this.resourceStore.findByType(server, "Group", resource -> {
            if (this.hasPermission((Resource)resource, null, VIEW_MEMBERS_SCOPE, MANAGE_MEMBERS_SCOPE)) {
                granted.add(resource.getName().substring(RESOURCE_NAME_PREFIX.length()));
            }
        });
        return granted;
    }

    @Override
    public void requireViewMembers(GroupModel group) {
        if (!this.getGroupsWithViewPermission(group)) {
            throw new ForbiddenException();
        }
    }

    @Override
    public boolean canViewMembers(GroupModel group) {
        if (this.root.users().canView()) {
            return true;
        }
        if (!this.root.isAdminSameRealm()) {
            return false;
        }
        ResourceServer server = this.root.realmResourceServer();
        if (server == null) {
            return false;
        }
        return this.hasPermission(group, VIEW_MEMBERS_SCOPE);
    }

    @Override
    public boolean canManageMembers(GroupModel group) {
        if (this.root.users().canManage()) {
            return true;
        }
        if (!this.root.isAdminSameRealm()) {
            return false;
        }
        ResourceServer server = this.root.realmResourceServer();
        if (server == null) {
            return false;
        }
        return this.hasPermission(group, MANAGE_MEMBERS_SCOPE);
    }

    @Override
    public boolean canManageMembership(GroupModel group) {
        if (this.canManage(group)) {
            return true;
        }
        if (!this.root.isAdminSameRealm()) {
            return false;
        }
        return this.hasPermission(group, MANAGE_MEMBERSHIP_SCOPE);
    }

    @Override
    public void requireManageMembership(GroupModel group) {
        if (!this.canManageMembership(group)) {
            throw new ForbiddenException();
        }
    }

    @Override
    public void requireManageMembers(GroupModel group) {
        if (!this.canManageMembers(group)) {
            throw new ForbiddenException();
        }
    }

    @Override
    public Map<String, Boolean> getAccess(GroupModel group) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("view", this.canView(group));
        map.put("manage", this.canManage(group));
        map.put("manageMembership", this.canManageMembership(group));
        map.put("viewMembers", this.canViewMembers(group));
        map.put("manageMembers", this.canManageMembers(group));
        return map;
    }

    private boolean hasPermission(GroupModel group, String ... scopes) {
        return this.hasPermission(group, (EvaluationContext)null, scopes);
    }

    private boolean hasPermission(GroupModel group, EvaluationContext context, String ... scopes) {
        ResourceServer server = this.root.realmResourceServer();
        if (server == null) {
            return false;
        }
        Resource resource = this.resourceStore.findByName(server, GroupPermissions.getGroupResourceName(group));
        if (resource == null) {
            return false;
        }
        return this.hasPermission(resource, context, scopes);
    }

    private boolean hasPermission(Resource resource, EvaluationContext context, String ... scopes) {
        ResourceServer server = this.root.realmResourceServer();
        Collection<Permission> permissions = context == null ? this.root.evaluatePermission(new ResourcePermission(resource, (Collection)resource.getScopes(), server), server) : this.root.evaluatePermission(new ResourcePermission(resource, (Collection)resource.getScopes(), server), server, context);
        List<String> expectedScopes = Arrays.asList(scopes);
        for (Permission permission : permissions) {
            for (String scope : permission.getScopes()) {
                if (!expectedScopes.contains(scope)) continue;
                return true;
            }
        }
        return false;
    }

    private Resource groupResource(GroupModel group) {
        ResourceServer server = this.root.realmResourceServer();
        if (server == null) {
            return null;
        }
        String groupResourceName = GroupPermissions.getGroupResourceName(group);
        return this.resourceStore.findByName(server, groupResourceName);
    }

    private void deletePermissions(GroupModel group) {
        Resource resource;
        Policy manageMembershipPermission;
        Policy viewMembersPermission;
        Policy manageMembersPermission;
        Policy viewPermission;
        ResourceServer server = this.root.realmResourceServer();
        if (server == null) {
            return;
        }
        Policy managePermission = this.managePermission(group);
        if (managePermission != null) {
            this.policyStore.delete(managePermission.getId());
        }
        if ((viewPermission = this.viewPermission(group)) != null) {
            this.policyStore.delete(viewPermission.getId());
        }
        if ((manageMembersPermission = this.manageMembersPermission(group)) != null) {
            this.policyStore.delete(manageMembersPermission.getId());
        }
        if ((viewMembersPermission = this.viewMembersPermission(group)) != null) {
            this.policyStore.delete(viewMembersPermission.getId());
        }
        if ((manageMembershipPermission = this.manageMembershipPermission(group)) != null) {
            this.policyStore.delete(manageMembershipPermission.getId());
        }
        if ((resource = this.groupResource(group)) != null) {
            this.resourceStore.delete(resource.getId());
        }
    }
}

