/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance.mappers;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.ProtocolMapper;
import org.keycloak.protocol.oid4vc.issuance.mappers.OID4VCMapper;
import org.keycloak.protocol.oid4vc.model.Role;
import org.keycloak.protocol.oid4vc.model.VerifiableCredential;
import org.keycloak.provider.ProviderConfigProperty;

public class OID4VCTargetRoleMapper
extends OID4VCMapper {
    private static final Logger LOGGER = Logger.getLogger(OID4VCTargetRoleMapper.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    public static final String MAPPER_ID = "oid4vc-target-role-mapper";
    public static final String SUBJECT_PROPERTY_CONFIG_KEY = "subjectProperty";
    public static final String CLIENT_CONFIG_KEY = "clientId";
    private static final List<ProviderConfigProperty> CONFIG_PROPERTIES = new ArrayList<ProviderConfigProperty>();

    @Override
    protected List<ProviderConfigProperty> getIndividualConfigProperties() {
        return CONFIG_PROPERTIES;
    }

    public String getDisplayType() {
        return "Target-Role Mapper";
    }

    public String getHelpText() {
        return "Map the assigned role to the credential subject, providing the client id as the target.";
    }

    public static ProtocolMapperModel create(String clientId, String name) {
        ProtocolMapperModel mapperModel = new ProtocolMapperModel();
        mapperModel.setName(name);
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put(SUBJECT_PROPERTY_CONFIG_KEY, "roles");
        configMap.put(CLIENT_CONFIG_KEY, clientId);
        mapperModel.setConfig(configMap);
        mapperModel.setProtocol("oid4vc");
        mapperModel.setProtocolMapper(MAPPER_ID);
        return mapperModel;
    }

    public ProtocolMapper create(KeycloakSession session) {
        return new OID4VCTargetRoleMapper();
    }

    public String getId() {
        return MAPPER_ID;
    }

    @Override
    public void setClaimsForCredential(VerifiableCredential verifiableCredential, UserSessionModel userSessionModel) {
    }

    @Override
    public void setClaimsForSubject(Map<String, Object> claims, UserSessionModel userSessionModel) {
        String client = (String)this.mapperModel.getConfig().get(CLIENT_CONFIG_KEY);
        String propertyName = (String)this.mapperModel.getConfig().get(SUBJECT_PROPERTY_CONFIG_KEY);
        ClientModel clientModel = userSessionModel.getRealm().getClientByClientId(client);
        if (clientModel == null || !clientModel.getProtocol().equals("oid4vc")) {
            return;
        }
        ClientRoleModel clientRoleModel = new ClientRoleModel(clientModel.getClientId(), userSessionModel.getUser().getClientRoleMappingsStream(clientModel).toList());
        Role rolesClaim = this.toRolesClaim(clientRoleModel);
        if (rolesClaim.getNames().isEmpty()) {
            return;
        }
        Map modelMap = (Map)OBJECT_MAPPER.convertValue((Object)this.toRolesClaim(clientRoleModel), Map.class);
        if (claims.containsKey(propertyName)) {
            Object object = claims.get(propertyName);
            if (object instanceof Set) {
                Set rolesProperty = (Set)object;
                rolesProperty.add(modelMap);
                claims.put(propertyName, rolesProperty);
            } else {
                LOGGER.warnf("Incompatible types for property %s. The mapper will not set the roles for client %s", (Object)propertyName, (Object)client);
            }
        } else {
            HashSet<Map> roles = new HashSet<Map>();
            roles.add(modelMap);
            claims.put(propertyName, roles);
        }
    }

    private Role toRolesClaim(ClientRoleModel crm) {
        Set<String> roleNames = crm.getRoleModels().stream().map(RoleModel::getName).collect(Collectors.toSet());
        return new Role(roleNames, crm.getClientId());
    }

    static {
        ProviderConfigProperty subjectPropertyNameConfig = new ProviderConfigProperty();
        subjectPropertyNameConfig.setName(SUBJECT_PROPERTY_CONFIG_KEY);
        subjectPropertyNameConfig.setLabel("Roles Property Name");
        subjectPropertyNameConfig.setHelpText("Property to add the roles to in the credential subject.");
        subjectPropertyNameConfig.setDefaultValue((Object)"roles");
        subjectPropertyNameConfig.setType("String");
        CONFIG_PROPERTIES.add(subjectPropertyNameConfig);
    }

    private static class ClientRoleModel {
        private final String clientId;
        private final List<RoleModel> roleModels;

        public ClientRoleModel(String clientId, List<RoleModel> roleModels) {
            this.clientId = clientId;
            this.roleModels = roleModels;
        }

        public String getClientId() {
            return this.clientId;
        }

        public List<RoleModel> getRoleModels() {
            return this.roleModels;
        }
    }
}

