/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.organization.forms.login.freemarker.model;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.keycloak.forms.login.freemarker.model.IdentityProviderBean;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;

public class OrganizationAwareIdentityProviderBean
extends IdentityProviderBean {
    private final KeycloakSession session;
    private final List<IdentityProviderBean.IdentityProvider> providers;

    public OrganizationAwareIdentityProviderBean(IdentityProviderBean delegate, KeycloakSession session, boolean onlyOrganizationBrokers) {
        this(delegate, session, onlyOrganizationBrokers, false);
    }

    public OrganizationAwareIdentityProviderBean(IdentityProviderBean delegate, KeycloakSession session, boolean onlyOrganizationBrokers, boolean onlyRealmBrokers) {
        this.session = session;
        this.providers = onlyRealmBrokers ? Optional.ofNullable(delegate.getProviders()).orElse(List.of()).stream().filter(Predicate.not(this::isPublicOrganizationBroker)).toList() : (onlyOrganizationBrokers ? Optional.ofNullable(delegate.getProviders()).orElse(List.of()).stream().filter(this::isPublicOrganizationBroker).toList() : Optional.ofNullable(delegate.getProviders()).orElse(List.of()).stream().filter(p -> this.isRealmBroker((IdentityProviderBean.IdentityProvider)p) || this.isPublicOrganizationBroker((IdentityProviderBean.IdentityProvider)p)).toList());
    }

    public OrganizationAwareIdentityProviderBean(IdentityProviderBean delegate, KeycloakSession session) {
        this(delegate, session, false);
    }

    @Override
    public List<IdentityProviderBean.IdentityProvider> getProviders() {
        return this.providers;
    }

    @Override
    public boolean isDisplayInfo() {
        return !this.providers.isEmpty();
    }

    private boolean isPublicOrganizationBroker(IdentityProviderBean.IdentityProvider idp) {
        RealmModel realm = this.session.getContext().getRealm();
        IdentityProviderModel model = realm.getIdentityProviderByAlias(idp.getAlias());
        if (model.getOrganizationId() == null) {
            return false;
        }
        return Boolean.parseBoolean(model.getConfig().getOrDefault("kc.org.broker.public", Boolean.FALSE.toString()));
    }

    private boolean isRealmBroker(IdentityProviderBean.IdentityProvider idp) {
        RealmModel realm = this.session.getContext().getRealm();
        IdentityProviderModel model = realm.getIdentityProviderByAlias(idp.getAlias());
        return model.getOrganizationId() == null;
    }
}

