/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.partialimport;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.partialimport.ErrorResponseException;
import org.keycloak.partialimport.PartialImport;
import org.keycloak.partialimport.PartialImportResult;
import org.keycloak.partialimport.PartialImportResults;
import org.keycloak.partialimport.ResourceType;
import org.keycloak.representations.idm.PartialImportRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.ServicesLogger;

public abstract class AbstractPartialImport<T>
implements PartialImport<T> {
    protected final Set<T> toOverwrite = new HashSet<T>();
    protected final Set<T> toSkip = new HashSet<T>();

    public abstract List<T> getRepList(PartialImportRepresentation var1);

    public abstract String getName(T var1);

    public abstract String getModelId(RealmModel var1, KeycloakSession var2, T var3);

    public abstract boolean exists(RealmModel var1, KeycloakSession var2, T var3);

    public abstract String existsMessage(RealmModel var1, T var2);

    public abstract ResourceType getResourceType();

    public abstract void remove(RealmModel var1, KeycloakSession var2, T var3);

    public abstract void create(RealmModel var1, KeycloakSession var2, T var3);

    @Override
    public void prepare(PartialImportRepresentation partialImportRep, RealmModel realm, KeycloakSession session) throws ErrorResponseException {
        List<T> repList = this.getRepList(partialImportRep);
        if (repList == null || repList.isEmpty()) {
            return;
        }
        block4: for (T resourceRep : this.getRepList(partialImportRep)) {
            if (!this.exists(realm, session, resourceRep)) continue;
            switch (partialImportRep.getPolicy()) {
                case SKIP: {
                    this.toSkip.add(resourceRep);
                    continue block4;
                }
                case OVERWRITE: {
                    this.toOverwrite.add(resourceRep);
                    continue block4;
                }
            }
            throw this.existsError(this.existsMessage(realm, resourceRep));
        }
    }

    protected ErrorResponseException existsError(String message) {
        throw ErrorResponse.exists(message);
    }

    protected PartialImportResult overwritten(String modelId, T resourceRep) {
        return PartialImportResult.overwritten((ResourceType)this.getResourceType(), (String)this.getName(resourceRep), (String)modelId, resourceRep);
    }

    protected PartialImportResult skipped(String modelId, T resourceRep) {
        return PartialImportResult.skipped((ResourceType)this.getResourceType(), (String)this.getName(resourceRep), (String)modelId, resourceRep);
    }

    protected PartialImportResult added(String modelId, T resourceRep) {
        return PartialImportResult.added((ResourceType)this.getResourceType(), (String)this.getName(resourceRep), (String)modelId, resourceRep);
    }

    @Override
    public void removeOverwrites(RealmModel realm, KeycloakSession session) {
        for (T resourceRep : this.toOverwrite) {
            this.remove(realm, session, resourceRep);
        }
    }

    @Override
    public PartialImportResults doImport(PartialImportRepresentation partialImportRep, RealmModel realm, KeycloakSession session) throws ErrorResponseException {
        String modelId;
        PartialImportResults results = new PartialImportResults();
        List<T> repList = this.getRepList(partialImportRep);
        if (repList == null || repList.isEmpty()) {
            return results;
        }
        for (T resourceRep : this.toOverwrite) {
            try {
                this.create(realm, session, resourceRep);
            }
            catch (Exception e) {
                ServicesLogger.LOGGER.overwriteError(e, this.getName(resourceRep));
                throw e;
            }
            modelId = this.getModelId(realm, session, resourceRep);
            results.addResult(this.overwritten(modelId, resourceRep));
        }
        for (T resourceRep : this.toSkip) {
            modelId = this.getModelId(realm, session, resourceRep);
            results.addResult(this.skipped(modelId, resourceRep));
        }
        for (T resourceRep : repList) {
            if (this.toOverwrite.contains(resourceRep) || this.toSkip.contains(resourceRep)) continue;
            try {
                this.create(realm, session, resourceRep);
                modelId = this.getModelId(realm, session, resourceRep);
                results.addResult(this.added(modelId, resourceRep));
            }
            catch (Exception e) {
                ServicesLogger.LOGGER.creationError(e, this.getName(resourceRep));
                throw e;
            }
        }
        return results;
    }
}

