/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol;

import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.UserModel;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.LoginProtocolFactory;
import org.keycloak.protocol.ProtocolMapper;

public class ProtocolMapperUtils {
    public static final String USER_ROLE = "user.role";
    public static final String USER_ATTRIBUTE = "user.attribute";
    public static final String USER_SESSION_NOTE = "user.session.note";
    public static final String MULTIVALUED = "multivalued";
    public static final String AGGREGATE_ATTRS = "aggregate.attrs";
    public static final String USER_MODEL_PROPERTY_LABEL = "usermodel.prop.label";
    public static final String USER_MODEL_PROPERTY_HELP_TEXT = "usermodel.prop.tooltip";
    public static final String USER_MODEL_ATTRIBUTE_LABEL = "usermodel.attr.label";
    public static final String USER_MODEL_ATTRIBUTE_HELP_TEXT = "usermodel.attr.tooltip";
    public static final String USER_MODEL_CLIENT_ROLE_MAPPING_CLIENT_ID = "usermodel.clientRoleMapping.clientId";
    public static final String USER_MODEL_CLIENT_ROLE_MAPPING_CLIENT_ID_LABEL = "usermodel.clientRoleMapping.clientId.label";
    public static final String USER_MODEL_CLIENT_ROLE_MAPPING_CLIENT_ID_HELP_TEXT = "usermodel.clientRoleMapping.clientId.tooltip";
    public static final String USER_MODEL_CLIENT_ROLE_MAPPING_ROLE_PREFIX = "usermodel.clientRoleMapping.rolePrefix";
    public static final String USER_MODEL_CLIENT_ROLE_MAPPING_ROLE_PREFIX_LABEL = "usermodel.clientRoleMapping.rolePrefix.label";
    public static final String USER_MODEL_CLIENT_ROLE_MAPPING_ROLE_PREFIX_HELP_TEXT = "usermodel.clientRoleMapping.rolePrefix.tooltip";
    public static final String USER_MODEL_REALM_ROLE_MAPPING_ROLE_PREFIX = "usermodel.realmRoleMapping.rolePrefix";
    public static final String USER_MODEL_REALM_ROLE_MAPPING_ROLE_PREFIX_LABEL = "usermodel.realmRoleMapping.rolePrefix.label";
    public static final String USER_MODEL_REALM_ROLE_MAPPING_ROLE_PREFIX_HELP_TEXT = "usermodel.realmRoleMapping.rolePrefix.tooltip";
    public static final String USER_SESSION_MODEL_NOTE_LABEL = "userSession.modelNote.label";
    public static final String USER_SESSION_MODEL_NOTE_HELP_TEXT = "userSession.modelNote.tooltip";
    public static final String MULTIVALUED_LABEL = "multivalued.label";
    public static final String AGGREGATE_ATTRS_LABEL = "aggregate.attrs.label";
    public static final String MULTIVALUED_HELP_TEXT = "multivalued.tooltip";
    public static final String AGGREGATE_ATTRS_HELP_TEXT = "aggregate.attrs.tooltip";
    public static final int SUB_MAPPER = -10;
    public static final int PRIORITY_ROLE_NAMES_MAPPER = 10;
    public static final int PRIORITY_HARDCODED_ROLE_MAPPER = 20;
    public static final int PRIORITY_AUDIENCE_RESOLVE_MAPPER = 30;
    public static final int PRIORITY_ROLE_MAPPER = 40;
    public static final int PRIORITY_SCRIPT_MAPPER = 50;

    public static String getUserModelValue(UserModel user, String propertyName) {
        Object val;
        Method method2;
        String methodName = "get" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        try {
            method2 = UserModel.class.getMethod(methodName, new Class[0]);
            val = method2.invoke((Object)user, new Object[0]);
            if (val != null) {
                return val.toString();
            }
        }
        catch (Exception method2) {
            // empty catch block
        }
        methodName = "is" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        try {
            method2 = UserModel.class.getMethod(methodName, new Class[0]);
            val = method2.invoke((Object)user, new Object[0]);
            if (val != null) {
                return val.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static ProtocolMapperModel findLocaleMapper(KeycloakSession session) {
        return session.getKeycloakSessionFactory().getProviderFactoriesStream(LoginProtocol.class).map(LoginProtocolFactory.class::cast).map(factory -> (ProtocolMapperModel)factory.getBuiltinMappers().get("locale")).filter(Objects::nonNull).filter(protocolMapper -> Objects.equals(protocolMapper.getProtocol(), "openid-connect")).findFirst().orElse(null);
    }

    public static Stream<Map.Entry<ProtocolMapperModel, ProtocolMapper>> getSortedProtocolMappers(KeycloakSession session, ClientSessionContext ctx) {
        return ProtocolMapperUtils.getSortedProtocolMappers(session, ctx, entry -> true);
    }

    public static Stream<Map.Entry<ProtocolMapperModel, ProtocolMapper>> getSortedProtocolMappers(KeycloakSession session, ClientSessionContext ctx, Predicate<Map.Entry<ProtocolMapperModel, ProtocolMapper>> filter) {
        KeycloakSessionFactory sessionFactory = session.getKeycloakSessionFactory();
        return ctx.getProtocolMappersStream().map(mapperModel -> {
            ProtocolMapper mapper = (ProtocolMapper)sessionFactory.getProviderFactory(ProtocolMapper.class, mapperModel.getProtocolMapper());
            if (mapper == null) {
                return null;
            }
            return new AbstractMap.SimpleEntry<ProtocolMapperModel, ProtocolMapper>((ProtocolMapperModel)mapperModel, mapper);
        }).filter(Objects::nonNull).filter(filter).sorted(Comparator.comparing(ProtocolMapperUtils::compare));
    }

    public static int compare(Map.Entry<ProtocolMapperModel, ProtocolMapper> entry) {
        int priority = entry.getValue().getPriority();
        return priority;
    }

    public static boolean isEnabled(KeycloakSession session, ProtocolMapperModel mapper) {
        return session.getKeycloakSessionFactory().getProviderFactory(ProtocolMapper.class, mapper.getProtocolMapper()) != null;
    }
}

