/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.vault;

import java.util.List;
import java.util.Optional;
import org.keycloak.vault.DefaultVaultRawSecret;
import org.keycloak.vault.VaultKeyResolver;
import org.keycloak.vault.VaultProvider;
import org.keycloak.vault.VaultRawSecret;

public abstract class AbstractVaultProvider
implements VaultProvider {
    protected final String realm;
    protected final List<VaultKeyResolver> resolvers;

    public AbstractVaultProvider(String realm, List<VaultKeyResolver> configuredResolvers) {
        this.realm = realm;
        this.resolvers = configuredResolvers;
    }

    public VaultRawSecret obtainSecret(String vaultSecretId) {
        for (VaultKeyResolver resolver : this.resolvers) {
            VaultRawSecret secret = this.obtainSecretInternal((String)resolver.apply((Object)this.realm, (Object)vaultSecretId));
            if (secret == null || !secret.get().isPresent()) continue;
            return secret;
        }
        return DefaultVaultRawSecret.forBuffer(Optional.empty());
    }

    protected abstract VaultRawSecret obtainSecretInternal(String var1);
}

