/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.browser;

import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.authenticators.browser.WebAuthnAuthenticatorFactory;
import org.keycloak.authentication.authenticators.browser.WebAuthnPasswordlessAuthenticator;
import org.keycloak.models.KeycloakSession;

public class WebAuthnPasswordlessAuthenticatorFactory
extends WebAuthnAuthenticatorFactory {
    public static final String PROVIDER_ID = "webauthn-authenticator-passwordless";

    @Override
    public String getReferenceCategory() {
        return "webauthn-passwordless";
    }

    @Override
    public String getDisplayType() {
        return "WebAuthn Passwordless Authenticator";
    }

    @Override
    public String getHelpText() {
        return "Authenticator for Passwordless WebAuthn authentication";
    }

    @Override
    public Authenticator create(KeycloakSession session) {
        return new WebAuthnPasswordlessAuthenticator(session);
    }

    @Override
    public String getId() {
        return PROVIDER_ID;
    }
}

