/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.requiredactions;

import org.keycloak.Config;
import org.keycloak.authentication.RequiredActionContext;
import org.keycloak.authentication.RequiredActionFactory;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.locale.LocaleSelectorProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;

public class UpdateUserLocaleAction
implements RequiredActionProvider,
RequiredActionFactory {
    public String getDisplayText() {
        return "Update User Locale";
    }

    public void evaluateTriggers(RequiredActionContext context) {
        String userRequestedLocale = context.getAuthenticationSession().getAuthNote("locale_user_requested");
        if (userRequestedLocale != null) {
            LocaleSelectorProvider provider = (LocaleSelectorProvider)context.getSession().getProvider(LocaleSelectorProvider.class);
            provider.updateUsersLocale(context.getUser(), userRequestedLocale);
        } else {
            String userLocale = context.getUser().getFirstAttribute("locale");
            LocaleSelectorProvider provider = (LocaleSelectorProvider)context.getSession().getProvider(LocaleSelectorProvider.class);
            if (userLocale != null) {
                provider.updateLocaleCookie(context.getRealm(), userLocale, context.getUriInfo());
            } else {
                provider.expireLocaleCookie(context.getRealm(), context.getUriInfo());
            }
        }
    }

    public void requiredActionChallenge(RequiredActionContext context) {
    }

    public void processAction(RequiredActionContext context) {
    }

    public RequiredActionProvider create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return "update_user_locale";
    }
}

