/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.oidc.mappers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.keycloak.broker.oidc.mappers.AbstractClaimMapper;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.IdentityBrokerException;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.ProviderConfigProperty;

public class AdvancedClaimToRoleMapper
extends AbstractClaimMapper {
    public static final String CLAIM_PROPERTY_NAME = "claims";
    public static final String ARE_CLAIM_VALUES_REGEX_PROPERTY_NAME = "are.claim.values.regex";
    public static final String[] COMPATIBLE_PROVIDERS = new String[]{"keycloak-oidc", "oidc"};
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();
    public static final String PROVIDER_ID = "oidc-advanced-role-idp-mapper";

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String[] getCompatibleProviders() {
        return COMPATIBLE_PROVIDERS;
    }

    public String getDisplayCategory() {
        return "Role Importer";
    }

    public String getDisplayType() {
        return "Advanced Claim to Role";
    }

    public void importNewUser(KeycloakSession session, RealmModel realm, UserModel user, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        String roleName = (String)mapperModel.getConfig().get("role");
        if (this.hasAllClaimValues(mapperModel, context)) {
            RoleModel role = KeycloakModelUtils.getRoleFromString((RealmModel)realm, (String)roleName);
            if (role == null) {
                throw new IdentityBrokerException("Unable to find role: " + roleName);
            }
            user.grantRole(role);
        }
    }

    public void updateBrokeredUser(KeycloakSession session, RealmModel realm, UserModel user, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        String roleName = (String)mapperModel.getConfig().get("role");
        if (!this.hasAllClaimValues(mapperModel, context)) {
            RoleModel role = KeycloakModelUtils.getRoleFromString((RealmModel)realm, (String)roleName);
            if (role == null) {
                throw new IdentityBrokerException("Unable to find role: " + roleName);
            }
            user.deleteRoleMapping(role);
        }
    }

    public String getHelpText() {
        return "If all claims exists, grant the user the specified realm or application role.";
    }

    protected boolean hasAllClaimValues(IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        Map claims = mapperModel.getConfigMap(CLAIM_PROPERTY_NAME);
        Boolean areClaimValuesRegex = Boolean.valueOf((String)mapperModel.getConfig().get(ARE_CLAIM_VALUES_REGEX_PROPERTY_NAME));
        for (Map.Entry claim : claims.entrySet()) {
            Object value = AdvancedClaimToRoleMapper.getClaimValue(context, (String)claim.getKey());
            boolean claimValuesMismatch = !(areClaimValuesRegex == false ? this.valueEquals((String)claim.getValue(), value) : this.valueMatchesRegex((String)claim.getValue(), value));
            if (!claimValuesMismatch) continue;
            return false;
        }
        return true;
    }

    public boolean valueMatchesRegex(String regex, Object value) {
        String stringValue;
        if (value instanceof List) {
            List list = (List)value;
            for (Object val : list) {
                if (!this.valueMatchesRegex(regex, val)) continue;
                return true;
            }
        } else if (value != null && (stringValue = value.toString()) != null && stringValue.matches(regex)) {
            return true;
        }
        return false;
    }

    static {
        ProviderConfigProperty claimsProperty = new ProviderConfigProperty();
        claimsProperty.setName(CLAIM_PROPERTY_NAME);
        claimsProperty.setLabel("Claims");
        claimsProperty.setHelpText("Name and value of the claims to search for in token. You can reference nested claims using a '.', i.e. 'address.locality'. To use dot (.) literally, escape it with backslash (\\.)");
        claimsProperty.setType("Map");
        configProperties.add(claimsProperty);
        ProviderConfigProperty isClaimValueRegexProperty = new ProviderConfigProperty();
        isClaimValueRegexProperty.setName(ARE_CLAIM_VALUES_REGEX_PROPERTY_NAME);
        isClaimValueRegexProperty.setLabel("Regex Claim Values");
        isClaimValueRegexProperty.setHelpText("If enabled claim values are interpreted as regular expressions.");
        isClaimValueRegexProperty.setType("boolean");
        configProperties.add(isClaimValueRegexProperty);
        ProviderConfigProperty roleProperty = new ProviderConfigProperty();
        roleProperty.setName("role");
        roleProperty.setLabel("Role");
        roleProperty.setHelpText("Role to grant to user if claim is present. Click 'Select Role' button to browse roles, or just type it in the textbox. To reference an application role the syntax is appname.approle, i.e. myapp.myrole");
        roleProperty.setType("Role");
        configProperties.add(roleProperty);
    }
}

