/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.credential;

import com.webauthn4j.data.WebAuthnAuthenticationContext;
import com.webauthn4j.data.attestation.authenticator.AttestedCredentialData;
import com.webauthn4j.data.attestation.authenticator.COSEKey;
import com.webauthn4j.data.attestation.statement.AttestationStatement;
import org.keycloak.common.util.Base64;
import org.keycloak.credential.CredentialInput;

public class WebAuthnCredentialModelInput
implements CredentialInput {
    private AttestedCredentialData attestedCredentialData;
    private AttestationStatement attestationStatement;
    private WebAuthnAuthenticationContext authenticationContext;
    private long count;
    private String credentialDBId;
    private final String credentialType;

    public WebAuthnCredentialModelInput(String credentialType) {
        this.credentialType = credentialType;
    }

    public String getCredentialId() {
        return this.credentialDBId;
    }

    public String getChallengeResponse() {
        throw new UnsupportedOperationException("WebAuthn credential doesn't support getChallengeResponse");
    }

    public String getType() {
        return this.credentialType;
    }

    public AttestedCredentialData getAttestedCredentialData() {
        return this.attestedCredentialData;
    }

    public AttestationStatement getAttestationStatement() {
        return this.attestationStatement;
    }

    public long getCount() {
        return this.count;
    }

    public WebAuthnAuthenticationContext getAuthenticationContext() {
        return this.authenticationContext;
    }

    public void setAuthenticationContext(WebAuthnAuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
    }

    public void setAttestedCredentialData(AttestedCredentialData attestedCredentialData) {
        this.attestedCredentialData = attestedCredentialData;
    }

    public void setAttestationStatement(AttestationStatement attestationStatement) {
        this.attestationStatement = attestationStatement;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public String getCredentialDBId() {
        return this.credentialDBId;
    }

    public void setCredentialDBId(String credentialDBId) {
        this.credentialDBId = credentialDBId;
    }

    public String getCredentialType() {
        return this.credentialType;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Credential Type = " + this.credentialType + ",");
        if (this.credentialDBId != null) {
            sb.append("Credential DB Id = ").append(this.credentialDBId).append(",");
        }
        if (this.attestationStatement != null) {
            sb.append("Attestation Statement Format = ").append(this.attestationStatement.getFormat()).append(",");
        }
        if (this.attestedCredentialData != null) {
            sb.append("AAGUID = ").append(this.attestedCredentialData.getAaguid().toString()).append(",");
            sb.append("CREDENTIAL_ID = ").append(Base64.encodeBytes((byte[])this.attestedCredentialData.getCredentialId())).append(",");
            COSEKey credPubKey = this.attestedCredentialData.getCOSEKey();
            byte[] keyId = credPubKey.getKeyId();
            if (keyId != null) {
                sb.append("CREDENTIAL_PUBLIC_KEY.key_id = ").append(Base64.encodeBytes((byte[])keyId)).append(",");
            }
            sb.append("CREDENTIAL_PUBLIC_KEY.algorithm = ").append(String.valueOf(credPubKey.getAlgorithm().getValue())).append(",");
            sb.append("CREDENTIAL_PUBLIC_KEY.key_type = ").append(credPubKey.getKeyType().name()).append(",");
        }
        if (this.authenticationContext != null) {
            sb.append("Credential Id = ").append(Base64.encodeBytes((byte[])this.authenticationContext.getCredentialId())).append(",");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.lastIndexOf(","));
        }
        return sb.toString();
    }
}

