/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.springsecurity.facade;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.keycloak.adapters.spi.AuthenticationError;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.adapters.spi.LogoutError;
import org.springframework.util.Assert;

class WrappedHttpServletRequest
implements HttpFacade.Request {
    private final HttpServletRequest request;
    private InputStream inputStream;

    public WrappedHttpServletRequest(HttpServletRequest request) {
        Assert.notNull((Object)request, (String)"HttpServletRequest required");
        this.request = request;
    }

    public String getFirstParam(String param) {
        return this.request.getParameter(param);
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public String getURI() {
        StringBuffer buf = this.request.getRequestURL();
        if (this.request.getQueryString() != null) {
            buf.append('?').append(this.request.getQueryString());
        }
        return buf.toString();
    }

    public String getRelativePath() {
        return this.request.getServletPath();
    }

    public boolean isSecure() {
        return this.request.isSecure();
    }

    public String getQueryParamValue(String param) {
        return this.request.getParameter(param);
    }

    public HttpFacade.Cookie getCookie(String cookieName) {
        Cookie[] cookies = this.request.getCookies();
        if (cookies == null) {
            return null;
        }
        for (Cookie cookie : this.request.getCookies()) {
            if (!cookie.getName().equals(cookieName)) continue;
            return new HttpFacade.Cookie(cookie.getName(), cookie.getValue(), cookie.getVersion(), cookie.getDomain(), cookie.getPath());
        }
        return null;
    }

    public String getHeader(String name) {
        return this.request.getHeader(name);
    }

    public List<String> getHeaders(String name) {
        Enumeration values = this.request.getHeaders(name);
        ArrayList array = new ArrayList();
        while (values.hasMoreElements()) {
            array.add(values.nextElement());
        }
        return Collections.unmodifiableList(array);
    }

    public InputStream getInputStream() {
        return this.getInputStream(false);
    }

    public InputStream getInputStream(boolean buffered) {
        if (this.inputStream != null) {
            return this.inputStream;
        }
        if (buffered) {
            try {
                this.inputStream = new BufferedInputStream((InputStream)this.request.getInputStream());
                return this.inputStream;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            return this.request.getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getRemoteAddr() {
        return this.request.getRemoteAddr();
    }

    public void setError(AuthenticationError error) {
        this.request.setAttribute(AuthenticationError.class.getName(), (Object)error);
    }

    public void setError(LogoutError error) {
        this.request.setAttribute(LogoutError.class.getName(), (Object)error);
    }
}

