/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.common.utils;

public class PackageClassNameUtils {
    private static final String FOLDER_SEPARATOR = "/";
    private static final String WINDOWS_FOLDER_SEPARATOR = "\\";

    private PackageClassNameUtils() {
    }

    public static String getSanitizedPackageName(String modelName) {
        return modelName.replaceAll("[^A-Za-z0-9.]", "").toLowerCase();
    }

    public static String getSanitizedClassName(String input) {
        String upperCasedInput = input.substring(0, 1).toUpperCase() + input.substring(1);
        return upperCasedInput.replaceAll("[^A-Za-z0-9]", "");
    }

    public static String[] getFactoryClassNamePackageName(String suffix, String sourcePath) {
        String fileName = (sourcePath = sourcePath.replace(WINDOWS_FOLDER_SEPARATOR, FOLDER_SEPARATOR)).substring(sourcePath.lastIndexOf(FOLDER_SEPARATOR) + 1);
        if (fileName.endsWith(suffix)) {
            fileName = fileName.substring(0, fileName.lastIndexOf(suffix) - 1);
        }
        String packageName = PackageClassNameUtils.getSanitizedPackageName(fileName);
        String factoryClassName = PackageClassNameUtils.getSanitizedClassName(fileName + "Factory");
        return new String[]{factoryClassName, packageName};
    }
}

