/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.lang.ast.visitor;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kie.dmn.feel.lang.CompilerContext;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.Symbol;
import org.kie.dmn.feel.lang.ast.ASTNode;
import org.kie.dmn.feel.lang.ast.ContextEntryNode;
import org.kie.dmn.feel.lang.ast.ContextNode;
import org.kie.dmn.feel.lang.ast.ForExpressionNode;
import org.kie.dmn.feel.lang.ast.FormalParameterNode;
import org.kie.dmn.feel.lang.ast.FunctionDefNode;
import org.kie.dmn.feel.lang.ast.FunctionInvocationNode;
import org.kie.dmn.feel.lang.ast.IterationContextNode;
import org.kie.dmn.feel.lang.ast.NameRefNode;
import org.kie.dmn.feel.lang.ast.QualifiedNameNode;
import org.kie.dmn.feel.lang.ast.QuantifiedExpressionNode;
import org.kie.dmn.feel.lang.ast.TemporalConstantNode;
import org.kie.dmn.feel.lang.ast.Visitor;
import org.kie.dmn.feel.lang.ast.visitor.DefaultedVisitor;
import org.kie.dmn.feel.parser.feel11.ScopeHelper;
import org.kie.dmn.feel.runtime.FEELFunction;
import org.kie.dmn.feel.runtime.functions.BuiltInFunctions;
import org.kie.dmn.feel.runtime.functions.DateAndTimeFunction;
import org.kie.dmn.feel.runtime.functions.DateFunction;
import org.kie.dmn.feel.runtime.functions.DurationFunction;
import org.kie.dmn.feel.runtime.functions.TimeFunction;
import org.kie.dmn.feel.util.EvalHelper;

public class ASTTemporalConstantVisitor
extends DefaultedVisitor<ASTNode> {
    private final ScopeHelper<FEELFunction> scopeHelper = new ScopeHelper();
    private static final FEELFunction MASKED = new DUMMY();
    public static final List<FEELFunction> TEMPORAL_FNS = Arrays.asList(DateFunction.INSTANCE, TimeFunction.INSTANCE, DateAndTimeFunction.INSTANCE, DurationFunction.INSTANCE);
    public static final Set<String> TEMPORAL_FNS_NAMES = TEMPORAL_FNS.stream().map(FEELFunction::getName).collect(Collectors.toSet());

    public ASTTemporalConstantVisitor(CompilerContext ctx) {
        Stream.of(BuiltInFunctions.getFunctions()).forEach(f -> this.scopeHelper.addInScope(f.getName(), f));
        for (FEELFunction f2 : ctx.getFEELFunctions()) {
            this.scopeHelper.addInScope(f2.getName(), (Object)f2);
        }
        ctx.getInputVariables().keySet().forEach(this::processNameInScope);
        ctx.getInputVariableTypes().keySet().forEach(this::processNameInScope);
    }

    private void processNameInScope(String n) {
        if (TEMPORAL_FNS_NAMES.contains(n)) {
            this.scopeHelper.addInScope(n, (Object)MASKED);
        }
    }

    public ASTNode defaultVisit(ASTNode n) {
        for (ASTNode children : n.getChildrenNode()) {
            if (children == null) continue;
            children.accept((Visitor)this);
        }
        return n;
    }

    public ASTNode visit(ASTNode n) {
        throw new UnsupportedOperationException();
    }

    public ASTNode visit(ForExpressionNode n) {
        this.scopeHelper.pushScope();
        for (IterationContextNode ic : n.getIterationContexts()) {
            ic.accept((Visitor)this);
            this.scopeHelper.addInScope(EvalHelper.normalizeVariableName(ic.getName().getText()), (Object)MASKED);
        }
        n.getExpression().accept((Visitor)this);
        this.scopeHelper.popScope();
        return n;
    }

    public ASTNode visit(ContextNode n) {
        this.scopeHelper.pushScope();
        for (ContextEntryNode ce : n.getEntries()) {
            ce.accept((Visitor)this);
            this.scopeHelper.addInScope(ce.getName().getText(), (Object)MASKED);
        }
        this.scopeHelper.popScope();
        return n;
    }

    public ASTNode visit(QuantifiedExpressionNode n) {
        this.scopeHelper.pushScope();
        for (IterationContextNode ic : n.getIterationContexts()) {
            ic.accept((Visitor)this);
            this.scopeHelper.addInScope(EvalHelper.normalizeVariableName(ic.getName().getText()), (Object)MASKED);
        }
        n.getExpression().accept((Visitor)this);
        this.scopeHelper.popScope();
        return n;
    }

    public ASTNode visit(FunctionDefNode n) {
        this.scopeHelper.pushScope();
        for (FormalParameterNode fp : n.getFormalParameters()) {
            this.scopeHelper.addInScope(EvalHelper.normalizeVariableName(fp.getName().getText()), (Object)MASKED);
        }
        n.getBody().accept((Visitor)this);
        this.scopeHelper.popScope();
        return n;
    }

    public ASTNode visit(FunctionInvocationNode n) {
        FEELFunction fn;
        Optional fnOpt;
        if (n.getName() instanceof NameRefNode) {
            fnOpt = this.scopeHelper.resolve(n.getName().getText());
        } else if (n.getName() instanceof QualifiedNameNode) {
            QualifiedNameNode qnn = (QualifiedNameNode)n.getName();
            String[] qns = qnn.getPartsAsStringArray();
            String qn = Stream.of(qns).collect(Collectors.joining(" "));
            fnOpt = this.scopeHelper.resolve(qn);
        } else {
            fnOpt = Optional.empty();
        }
        if (fnOpt.isPresent() && TEMPORAL_FNS.contains(fn = (FEELFunction)fnOpt.get())) {
            try {
                TemporalConstantNode tcNode = this.buildTemporalConstantNode(n, fn);
                n.setTcFolded(tcNode);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return (ASTNode)super.visit(n);
    }

    private TemporalConstantNode buildTemporalConstantNode(FunctionInvocationNode n, FEELFunction fn) {
        switch (fn.getName()) {
            case "date": {
                return this.buildTCNodeForDate(n, fn);
            }
            case "date and time": {
                return this.buildTCNodeForDateAndTime(n, fn);
            }
            case "time": {
                return this.buildTCNodeForTime(n, fn);
            }
            case "duration": {
                return this.buildTCNodeForDuration(n, fn);
            }
        }
        return null;
    }

    private TemporalConstantNode buildTCNodeForDuration(FunctionInvocationNode n, FEELFunction fn) {
        return null;
    }

    private TemporalConstantNode buildTCNodeForTime(FunctionInvocationNode n, FEELFunction fn) {
        return null;
    }

    private TemporalConstantNode buildTCNodeForDateAndTime(FunctionInvocationNode n, FEELFunction fn) {
        return null;
    }

    private TemporalConstantNode buildTCNodeForDate(FunctionInvocationNode n, FEELFunction fn) {
        return null;
    }

    private static final class DUMMY
    implements FEELFunction {
        private DUMMY() {
        }

        public String getName() {
            return "DUMMY";
        }

        public Symbol getSymbol() {
            throw new UnsupportedOperationException();
        }

        public List<List<FEELFunction.Param>> getParameters() {
            throw new UnsupportedOperationException();
        }

        public Object invokeReflectively(EvaluationContext ctx, Object[] params) {
            throw new UnsupportedOperationException();
        }
    }
}

