/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.compiler.io.memory;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.drools.compiler.commons.jci.readers.ResourceReader;
import org.drools.compiler.commons.jci.stores.ResourceStore;
import org.drools.compiler.compiler.io.File;
import org.drools.compiler.compiler.io.FileSystem;
import org.drools.compiler.compiler.io.FileSystemItem;
import org.drools.compiler.compiler.io.Folder;
import org.drools.compiler.compiler.io.Path;
import org.drools.compiler.compiler.io.memory.MemoryFile;
import org.drools.compiler.compiler.io.memory.MemoryFolder;
import org.drools.core.io.impl.ByteArrayResource;
import org.drools.core.io.internal.InternalResource;
import org.drools.core.util.IoUtils;
import org.drools.core.util.StringUtils;
import org.kie.api.io.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryFileSystem
implements FileSystem,
ResourceReader,
Serializable,
ResourceStore {
    private static final Logger log = LoggerFactory.getLogger(MemoryFileSystem.class);
    private final MemoryFolder folder;
    private final Map<String, Set<FileSystemItem>> folders = new HashMap<String, Set<FileSystemItem>>();
    private final Map<String, Folder> folderMap = new HashMap<String, Folder>();
    private final Map<String, InternalResource> fileContents = new HashMap<String, InternalResource>();
    private Set<String> modifiedFilesSinceLastMark;

    public MemoryFileSystem() {
        this.folder = new MemoryFolder(this, "");
        this.folders.put("", new HashSet());
    }

    @Override
    public Folder getRootFolder() {
        return this.folder;
    }

    @Override
    public File getFile(Path path) {
        return this.getFile(path.toPortableString());
    }

    @Override
    public Collection<String> getFileNames() {
        return this.fileContents.keySet();
    }

    public Map<String, byte[]> getMap() {
        HashMap<String, byte[]> bytesMap = new HashMap<String, byte[]>();
        for (Map.Entry<String, InternalResource> kv : this.fileContents.entrySet()) {
            bytesMap.put(kv.getKey(), this.resourceToBytes((Resource)kv.getValue()));
        }
        return bytesMap;
    }

    private byte[] resourceToBytes(Resource resource) {
        return resource != null ? ((InternalResource)resource).getBytes() : null;
    }

    @Override
    public File getFile(String path) {
        int lastSlashPos = (path = MemoryFolder.trimLeadingAndTrailing(path)).lastIndexOf(47);
        if (lastSlashPos >= 0) {
            Folder folder = this.getFolder(path.substring(0, lastSlashPos));
            String name = path.substring(lastSlashPos + 1);
            return new MemoryFile(this, name, folder);
        }
        Folder folder = this.getRootFolder();
        return new MemoryFile(this, path, folder);
    }

    @Override
    public Folder getFolder(Path path) {
        return this.getFolder(path.toPortableString());
    }

    @Override
    public Folder getFolder(String path) {
        Folder folder = this.folderMap.get(path);
        if (folder == null) {
            folder = new MemoryFolder(this, path);
            this.folderMap.put(path, folder);
        }
        return folder;
    }

    public Set<? extends FileSystemItem> getMembers(Folder folder) {
        return this.folders.get(folder.getPath().toPortableString());
    }

    public byte[] getFileContents(MemoryFile file) {
        return this.resourceToBytes((Resource)this.getResource(file));
    }

    public InternalResource getResource(MemoryFile file) {
        return this.fileContents.get(file.getPath().toPortableString());
    }

    public void setFileContents(MemoryFile file, byte[] contents) throws IOException {
        this.setFileContents(file, (Resource)new ByteArrayResource(contents));
    }

    public void setFileContents(MemoryFile file, Resource resource) throws IOException {
        if (!this.existsFolder((MemoryFolder)file.getFolder())) {
            this.createFolder((MemoryFolder)file.getFolder());
        }
        String fileName = file.getPath().toPortableString();
        if (this.modifiedFilesSinceLastMark != null) {
            byte[] contents = this.resourceToBytes(resource);
            byte[] oldContent = this.resourceToBytes((Resource)this.fileContents.get(fileName));
            if (oldContent == null || !Arrays.equals(oldContent, contents)) {
                this.modifiedFilesSinceLastMark.add(fileName);
            }
        }
        this.fileContents.put(fileName, (InternalResource)resource);
        resource.setSourcePath(file.getPath().toPortableString());
        this.folders.get(file.getFolder().getPath().toPortableString()).add(file);
    }

    @Override
    public void mark() {
        this.modifiedFilesSinceLastMark = new HashSet<String>();
    }

    @Override
    public Collection<String> getModifiedResourcesSinceLastMark() {
        return this.modifiedFilesSinceLastMark;
    }

    public boolean existsFolder(MemoryFolder folder) {
        return this.existsFolder(folder.getPath().toPortableString());
    }

    public boolean existsFolder(String path) {
        if (path == null) {
            throw new NullPointerException("Folder path can not be null!");
        }
        return this.folders.get(MemoryFolder.trimLeadingAndTrailing(path)) != null;
    }

    public boolean existsFile(String path) {
        if (path == null) {
            throw new NullPointerException("File path can not be null!");
        }
        return this.fileContents.containsKey(MemoryFolder.trimLeadingAndTrailing(path));
    }

    public void createFolder(MemoryFolder folder) {
        if (!this.existsFolder(folder)) {
            if (!this.existsFolder((MemoryFolder)folder.getParent())) {
                this.createFolder((MemoryFolder)folder.getParent());
            }
            this.folders.put(folder.getPath().toPortableString(), new HashSet());
            Folder parent = folder.getParent();
            this.folders.get(parent.getPath().toPortableString()).add(folder);
        }
    }

    @Override
    public boolean remove(Folder folder) {
        if (folder.exists()) {
            this.remove(this.folders.get(folder.getPath().toPortableString()));
            this.folders.remove(folder.getPath().toPortableString());
            return true;
        }
        return false;
    }

    public void remove(Set<FileSystemItem> members) {
        Iterator<FileSystemItem> it = members.iterator();
        while (it.hasNext()) {
            FileSystemItem res = it.next();
            if (res instanceof Folder) {
                this.remove(this.folders.get(res.getPath().toPortableString()));
            } else {
                String fileName = res.getPath().toPortableString();
                this.fileContents.remove(fileName);
                if (this.modifiedFilesSinceLastMark != null) {
                    this.modifiedFilesSinceLastMark.add(fileName);
                }
            }
            it.remove();
        }
    }

    @Override
    public boolean remove(File file) {
        if (file.exists()) {
            String fileName = file.getPath().toPortableString();
            this.fileContents.remove(fileName);
            if (this.modifiedFilesSinceLastMark != null) {
                this.modifiedFilesSinceLastMark.add(fileName);
            }
            this.folders.get(((MemoryFile)file).getFolder().getPath().toPortableString()).remove(file);
            return true;
        }
        return false;
    }

    public int copyFolder(Folder srcFolder, MemoryFileSystem trgMfs, Folder trgFolder, String ... filters) {
        return MemoryFileSystem.copyFolder(this, srcFolder, trgMfs, trgFolder, 0, filters);
    }

    private static int copyFolder(MemoryFileSystem srcMfs, Folder srcFolder, MemoryFileSystem trgMfs, Folder trgFolder, int count, String ... filters) {
        if (!trgFolder.exists()) {
            trgMfs.getFolder(trgFolder.getPath()).create();
        }
        if (srcFolder != null) {
            for (FileSystemItem fileSystemItem : srcFolder.getMembers()) {
                if (fileSystemItem instanceof Folder) {
                    count = MemoryFileSystem.copyFolder(srcMfs, (Folder)fileSystemItem, trgMfs, trgFolder.getFolder(((Folder)fileSystemItem).getName()), count, filters);
                    continue;
                }
                MemoryFile trgFile = (MemoryFile)trgFolder.getFile(((File)fileSystemItem).getName());
                boolean accept = false;
                if (filters == null || filters.length == 0) {
                    accept = true;
                } else {
                    for (String filter : filters) {
                        if (!trgFile.getName().endsWith(filter)) continue;
                        accept = true;
                        break;
                    }
                }
                if (!accept) continue;
                try {
                    trgMfs.setFileContents(trgFile, (Resource)srcMfs.getResource((MemoryFile)fileSystemItem));
                    ++count;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return count;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.fileContents.hashCode();
        result = 31 * result + (this.folder == null ? 0 : this.folder.hashCode());
        result = 31 * result + this.folders.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MemoryFileSystem other = (MemoryFileSystem)obj;
        if (this.folder == null ? other.folder != null : !this.folder.equals(other.folder)) {
            return false;
        }
        return this.fileContents.equals(other.fileContents) && this.folders.equals(other.folders);
    }

    public String toString() {
        return "MemoryFileSystem [folder=" + this.folder + ", folders=" + this.folders + ", fileContents=" + this.fileContents + "]";
    }

    public void printFs(PrintStream out) {
        this.printFs(this.getRootFolder(), out);
    }

    public void printFs(Folder f, PrintStream out) {
        for (FileSystemItem fileSystemItem : f.getMembers()) {
            out.println(fileSystemItem);
            if (fileSystemItem instanceof Folder) {
                this.printFs((Folder)fileSystemItem, out);
                continue;
            }
            out.println(new String(this.getFileContents((MemoryFile)fileSystemItem), IoUtils.UTF8_CHARSET));
        }
    }

    @Override
    public boolean isAvailable(String pResourceName) {
        return this.existsFile(pResourceName);
    }

    @Override
    public byte[] getBytes(String pResourceName) {
        return this.getFileContents((MemoryFile)this.getFile(pResourceName));
    }

    @Override
    public InternalResource getResource(String pResourceName) {
        return this.getResource((MemoryFile)this.getFile(pResourceName));
    }

    @Override
    public void write(String pResourceName, byte[] pResourceData) {
        this.write(pResourceName, pResourceData, false);
    }

    @Override
    public void write(String pResourceName, byte[] pResourceData, boolean createFolder) {
        this.write(pResourceName, (Resource)new ByteArrayResource(pResourceData), createFolder);
    }

    public void write(String pResourceName, Resource resource) {
        this.write(pResourceName, resource, false);
    }

    public void write(String pResourceName, Resource resource, boolean createFolder) {
        String folderPath;
        if ((pResourceName = pResourceName.replace(java.io.File.separatorChar, '/')).endsWith("/")) {
            return;
        }
        MemoryFile memoryFile = (MemoryFile)this.getFile(pResourceName);
        if (createFolder && !this.existsFolder(folderPath = memoryFile.getFolder().getPath().toPortableString())) {
            memoryFile.getFolder().create();
        }
        try {
            this.setFileContents(memoryFile, resource);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] read(String pResourceName) {
        return this.getBytes(pResourceName);
    }

    @Override
    public void remove(String pResourceName) {
        this.remove(this.getFile(pResourceName));
    }

    public byte[] writeAsBytes() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.zip(baos);
        return baos.toByteArray();
    }

    public java.io.File writeAsJar(java.io.File folder, String jarName) {
        try {
            java.io.File jarFile = new java.io.File(folder, jarName + ".jar");
            System.out.println(jarFile);
            this.zip(new FileOutputStream(jarFile));
            return jarFile;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void zip(OutputStream outputStream) {
        ZipOutputStream out = null;
        try {
            out = new ZipOutputStream(outputStream);
            this.writeJarEntries(this.getRootFolder(), out);
            out.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void writeAsFs(java.io.File file) {
        file.mkdir();
        this.writeAsFs(this.getRootFolder(), file);
    }

    public void writeAsFs(Folder f, java.io.File file1) {
        for (FileSystemItem fileSystemItem : f.getMembers()) {
            if (fileSystemItem instanceof Folder) {
                java.io.File file2 = new java.io.File(file1, ((Folder)fileSystemItem).getName());
                file2.mkdir();
                this.writeAsFs((Folder)fileSystemItem, file2);
                continue;
            }
            byte[] bytes = this.getFileContents((MemoryFile)fileSystemItem);
            try {
                IoUtils.write((java.io.File)new java.io.File(file1, ((File)fileSystemItem).getName()), (byte[])bytes);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to write project to file system\n", e);
            }
        }
    }

    private void writeJarEntries(Folder f, ZipOutputStream out) throws IOException {
        for (FileSystemItem fileSystemItem : f.getMembers()) {
            ZipEntry entry;
            Object rname = fileSystemItem.getPath().toPortableString();
            if (fileSystemItem instanceof Folder) {
                rname = ((String)rname).endsWith("/") ? rname : (String)rname + "/";
                entry = new ZipEntry((String)rname);
                out.putNextEntry(entry);
                this.writeJarEntries((Folder)fileSystemItem, out);
                continue;
            }
            entry = new ZipEntry((String)rname);
            out.putNextEntry(entry);
            byte[] contents = this.getFileContents((MemoryFile)fileSystemItem);
            if (contents == null) {
                IOException e = new IOException("No content found for: " + fileSystemItem);
                log.error(e.getMessage(), (Throwable)e);
                throw e;
            }
            out.write(contents);
            out.closeEntry();
        }
    }

    public static MemoryFileSystem readFromJar(java.io.File jarFile) {
        MemoryFileSystem mfs = new MemoryFileSystem();
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(jarFile);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                int separator = entry.getName().lastIndexOf(47);
                String path = separator > 0 ? entry.getName().substring(0, separator) : "";
                String name = entry.getName().substring(separator + 1);
                Folder folder = mfs.getFolder(path);
                folder.create();
                File file = folder.getFile(name);
                file.create(zipFile.getInputStream(entry));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return mfs;
    }

    public static MemoryFileSystem readFromJar(byte[] jarFile) {
        return MemoryFileSystem.readFromJar(new ByteArrayInputStream(jarFile));
    }

    public static MemoryFileSystem readFromJar(InputStream jarFile) {
        MemoryFileSystem mfs = new MemoryFileSystem();
        JarInputStream zipFile = null;
        try {
            ZipEntry entry;
            zipFile = new JarInputStream(jarFile);
            while ((entry = zipFile.getNextEntry()) != null) {
                int b;
                if (entry.isDirectory()) continue;
                ByteArrayOutputStream content = new ByteArrayOutputStream();
                while ((b = zipFile.read()) != -1) {
                    content.write(b);
                }
                mfs.write(entry.getName(), content.toByteArray(), true);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return mfs;
    }

    public String findPomProperties() {
        for (Map.Entry<String, InternalResource> content : this.fileContents.entrySet()) {
            String string;
            block9: {
                if (!content.getKey().endsWith("pom.properties") || !content.getKey().startsWith("META-INF/maven/")) continue;
                InputStream resourceStream = content.getValue().getInputStream();
                try {
                    string = StringUtils.readFileAsString((Reader)new InputStreamReader(resourceStream, IoUtils.UTF8_CHARSET));
                    if (resourceStream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (resourceStream != null) {
                            try {
                                resourceStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException(ioe);
                    }
                }
                resourceStream.close();
            }
            return string;
        }
        return null;
    }

    public MemoryFileSystem clone() {
        MemoryFileSystem clone = new MemoryFileSystem();
        for (Map.Entry<String, InternalResource> entry : this.fileContents.entrySet()) {
            clone.write(entry.getKey(), (Resource)entry.getValue());
        }
        return clone;
    }
}

