/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.spring.auth;

import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import org.kie.kogito.auth.IdentityProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
public class SpringIdentityProvider
implements IdentityProvider {
    private Optional<Authentication> getAuthentication() {
        return Optional.ofNullable(SecurityContextHolder.getContext().getAuthentication());
    }

    public String getName() {
        return this.getAuthentication().map(Principal::getName).orElse(null);
    }

    public Collection<String> getRoles() {
        return this.getAuthentication().map(a -> a.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toSet())).orElse(Collections.emptySet());
    }

    public boolean hasRole(String role) {
        return this.getAuthentication().map(a -> a.getAuthorities().stream().anyMatch(auth -> auth.getAuthority().equals(role))).orElse(false);
    }
}

