/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.rules.units;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.time.SessionClock;
import org.kie.kogito.rules.DataProcessor;
import org.kie.kogito.rules.DataSource;
import org.kie.kogito.rules.RuleUnit;
import org.kie.kogito.rules.RuleUnitData;
import org.kie.kogito.rules.RuleUnitInstance;
import org.kie.kogito.rules.RuleUnitQuery;
import org.kie.kogito.rules.units.EntryPointDataProcessor;

public class AbstractRuleUnitInstance<T extends RuleUnitData>
implements RuleUnitInstance<T> {
    private final T unitMemory;
    private final RuleUnit<T> unit;
    private final KieSession runtime;

    public AbstractRuleUnitInstance(RuleUnit<T> unit, T unitMemory, KieSession runtime) {
        this.unit = unit;
        this.runtime = runtime;
        this.unitMemory = unitMemory;
        this.bind(runtime, unitMemory);
    }

    public int fire() {
        return this.runtime.fireAllRules();
    }

    public List<Map<String, Object>> executeQuery(String query) {
        this.fire();
        return this.runtime.getQueryResults(query, new Object[0]).toList();
    }

    public <Q> Q executeQuery(Class<? extends RuleUnitQuery<Q>> query) {
        return (Q)this.createRuleUnitQuery(query).execute();
    }

    protected <Q> RuleUnitQuery<Q> createRuleUnitQuery(Class<? extends RuleUnitQuery<Q>> query) {
        try {
            return query.getConstructor(RuleUnitInstance.class).newInstance(this);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public RuleUnit<T> unit() {
        return this.unit;
    }

    public <C extends SessionClock> C getClock() {
        return (C)this.runtime.getSessionClock();
    }

    public T workingMemory() {
        return this.unitMemory;
    }

    protected void bind(KieSession runtime, T workingMemory) {
        try {
            for (Field f : workingMemory.getClass().getDeclaredFields()) {
                f.setAccessible(true);
                Object v = null;
                v = f.get(workingMemory);
                String dataSourceName = String.format("%s.%s", workingMemory.getClass().getCanonicalName(), f.getName());
                if (v instanceof DataSource) {
                    DataSource o = (DataSource)v;
                    EntryPoint ep = runtime.getEntryPoint(dataSourceName);
                    o.subscribe((DataProcessor)new EntryPointDataProcessor(ep));
                }
                try {
                    runtime.setGlobal(dataSourceName, v);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
    }
}

