/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.services.event.impl;

import java.util.Optional;
import org.kie.kogito.Application;
import org.kie.kogito.Model;
import org.kie.kogito.process.Process;
import org.kie.kogito.services.event.AbstractProcessDataEvent;
import org.kie.kogito.services.event.EventConsumerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMessageConsumer<M extends Model, D, T extends AbstractProcessDataEvent<D>> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractMessageConsumer.class);
    private Process<M> process;
    private Application application;
    private EventConsumerFactory eventConsumerFactory;
    private Optional<Boolean> useCloudEvents;
    private String trigger;
    private Class<D> dataEventClass;
    private Class<T> cloudEventClass;

    public AbstractMessageConsumer() {
    }

    public AbstractMessageConsumer(Application application, Process<M> process, Class<D> dataEventClass, Class<T> cloudEventClass, String trigger, EventConsumerFactory eventConsumerFactory, Optional<Boolean> useCloudEvents) {
        this.setParams(application, process, dataEventClass, cloudEventClass, trigger, eventConsumerFactory, useCloudEvents);
    }

    public void setParams(Application application, Process<M> process, Class<D> dataEventClass, Class<T> cloudEventClass, String trigger, EventConsumerFactory eventConsumerFactory, Optional<Boolean> useCloudEvents) {
        this.process = process;
        this.application = application;
        this.dataEventClass = dataEventClass;
        this.cloudEventClass = cloudEventClass;
        this.eventConsumerFactory = eventConsumerFactory;
        this.trigger = trigger;
        this.useCloudEvents = useCloudEvents;
        logger.info("Consumer for {} started.", dataEventClass);
    }

    public void consume(String payload) {
        logger.debug("Received: {} on thread {}", (Object)payload, (Object)Thread.currentThread().getName());
        this.eventConsumerFactory.get(this::eventToModel, this.dataEventClass, this.cloudEventClass, this.useCloudEvents).consume(this.application, this.process, payload, this.trigger);
    }

    protected abstract Model eventToModel(D var1);
}

