/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl;

import java.io.PrintStream;
import org.kie.api.KieServices;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.Results;
import org.kie.api.runtime.KieContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieServerContainerVerifier {
    private static final Logger logger = LoggerFactory.getLogger(KieServerContainerVerifier.class);
    static final String USAGE = "Usage: java " + KieServerContainerVerifier.class.getName() + " <gav1> <gav2> ...\n";

    public boolean verify(String releaseId) {
        boolean verified;
        try {
            String[] gav = releaseId.split(":");
            verified = this.verify(gav[0], gav[1], gav[2]);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            verified = false;
        }
        return verified;
    }

    public boolean verify(String groupId, String artifactId, String version) {
        boolean verified;
        KieServices services = KieServices.Factory.get();
        try {
            ReleaseId releaseId = services.newReleaseId(groupId, artifactId, version);
            verified = this.verify(releaseId);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            verified = false;
        }
        return verified;
    }

    public boolean verify(ReleaseId releaseId) {
        boolean verified;
        KieServices services = KieServices.Factory.get();
        try {
            KieContainer container = services.newKieContainer(releaseId);
            verified = this.verify(container);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            verified = false;
        }
        return verified;
    }

    public boolean verify(KieContainer container) {
        boolean verified = true;
        try {
            Results results = container.verify();
            for (Message message : results.getMessages()) {
                Message.Level level = message.getLevel();
                switch (level) {
                    case INFO: {
                        logger.info(message.toString());
                        break;
                    }
                    case WARNING: {
                        logger.warn(message.toString());
                        break;
                    }
                    case ERROR: {
                        logger.error(message.toString());
                        verified = false;
                    }
                }
            }
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            verified = false;
        }
        return verified;
    }

    public static void main(String[] args) {
        boolean verified = KieServerContainerVerifier.main(args, System.out, System.err);
        if (!verified) {
            System.exit(1);
        }
    }

    static boolean main(String[] args, PrintStream out, PrintStream err) {
        boolean triggered = false;
        boolean verified = true;
        if (args != null && args.length > 0) {
            KieServerContainerVerifier verifier = new KieServerContainerVerifier();
            for (String arg : args) {
                if (arg == null || (arg = arg.trim()).isEmpty()) continue;
                triggered = true;
                if (verifier.verify(arg)) {
                    logger.info(arg + " verified.");
                    continue;
                }
                logger.error(arg + " not verified.");
                verified = false;
            }
        }
        if (!triggered) {
            err.print(USAGE);
        }
        return verified;
    }
}

