/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.json;

import org.dashbuilder.dataset.def.KafkaDataSetDef;
import org.dashbuilder.dataset.json.DataSetDefJSONMarshaller;
import org.dashbuilder.dataset.json.DataSetDefJSONMarshallerExt;
import org.dashbuilder.json.JsonObject;

public class KafkaDefJSONMarshaller
implements DataSetDefJSONMarshallerExt<KafkaDataSetDef> {
    public static final KafkaDefJSONMarshaller INSTANCE = new KafkaDefJSONMarshaller();
    public static final String HOST = "host";
    public static final String PORT = "port";
    public static final String TARGET = "target";
    public static final String FILTER = "filter";
    public static final String CLIENT_ID = "clientId";
    public static final String NODE_ID = "nodeId";
    public static final String TOPIC = "topic";
    public static final String PARTITION = "partition";

    @Override
    public void fromJson(KafkaDataSetDef def, JsonObject json) {
        DataSetDefJSONMarshaller.transferStringValue(HOST, json, def::setHost);
        DataSetDefJSONMarshaller.transferStringValue(PORT, json, def::setPort);
        DataSetDefJSONMarshaller.transferStringValue(TARGET, json, v -> def.setTarget(KafkaDataSetDef.MetricsTarget.valueOf(v)));
        DataSetDefJSONMarshaller.transferStringValue(FILTER, json, def::setFilter);
        DataSetDefJSONMarshaller.transferStringValue(CLIENT_ID, json, def::setClientId);
        DataSetDefJSONMarshaller.transferStringValue(NODE_ID, json, def::setNodeId);
        DataSetDefJSONMarshaller.transferStringValue(TOPIC, json, def::setTopic);
        DataSetDefJSONMarshaller.transferStringValue(PARTITION, json, def::setPartition);
    }

    @Override
    public void toJson(KafkaDataSetDef def, JsonObject json) {
        json.put(HOST, def.getHost());
        json.put(PORT, def.getPort());
        json.put(TARGET, def.getTarget().name());
        json.put(FILTER, def.getFilter());
        json.put(CLIENT_ID, def.getClientId());
        json.put(NODE_ID, def.getNodeId());
        json.put(TOPIC, def.getTopic());
        json.put(PARTITION, def.getPartition());
        json.put("allColumns", def.isAllColumnsEnabled());
    }
}

