/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.kafka.mbean;

import java.util.Collections;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXServiceURL;
import org.dashbuilder.dataprovider.kafka.mbean.JMXRMIConnectorProvider;
import org.dashbuilder.dataprovider.kafka.model.KafkaMetricsRequest;

public class MBeanServerConnectionProvider {
    private static final String RMI_URL_TEMPLATE = "service:jmx:rmi:///jndi/rmi://%s:%s/jmxrmi";
    private static final JMXRMIConnectorProvider PROVIDER = new JMXRMIConnectorProvider();

    private MBeanServerConnectionProvider() {
    }

    public static JMXConnector newConnection(KafkaMetricsRequest request) {
        try {
            String host = request.getHost();
            String port = request.getRmiPort();
            MBeanServerConnectionProvider.validateParams(host, port);
            String formattedUrl = String.format(RMI_URL_TEMPLATE, host, port);
            JMXServiceURL url = new JMXServiceURL(formattedUrl);
            JMXConnector connector = PROVIDER.newJMXConnector(url, Collections.emptyMap());
            connector.connect();
            return connector;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Not able to connect to provided server.", e);
        }
    }

    private static void validateParams(String host, String port) {
        if (host == null || host.trim().isEmpty()) {
            throw new IllegalArgumentException("Invalid host name.");
        }
        if (MBeanServerConnectionProvider.isInvalid(port)) {
            throw new IllegalArgumentException("Invalid port.");
        }
    }

    private static boolean isInvalid(String port) {
        try {
            return port == null || Integer.parseInt(port) < 1024;
        }
        catch (NumberFormatException e) {
            return true;
        }
    }
}

