/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.kafka.metrics.group;

import java.util.EnumMap;
import org.dashbuilder.dataprovider.kafka.metrics.group.BrokerMetricsGroup;
import org.dashbuilder.dataprovider.kafka.metrics.group.ConsumerMetricsGroup;
import org.dashbuilder.dataprovider.kafka.metrics.group.MetricsCollectorGroup;
import org.dashbuilder.dataprovider.kafka.metrics.group.ProducerMetricsGroup;
import org.dashbuilder.dataset.def.KafkaDataSetDef;

public class MetricsCollectorGroupFactory {
    private static MetricsCollectorGroupFactory instance;
    private static EnumMap<KafkaDataSetDef.MetricsTarget, MetricsCollectorGroup> groups;

    MetricsCollectorGroupFactory() {
    }

    public static MetricsCollectorGroupFactory get() {
        return instance;
    }

    public MetricsCollectorGroup forTarget(KafkaDataSetDef.MetricsTarget target) {
        return groups.get(target);
    }

    static {
        groups = new EnumMap(KafkaDataSetDef.MetricsTarget.class);
        instance = new MetricsCollectorGroupFactory();
        groups.put(KafkaDataSetDef.MetricsTarget.BROKER, new BrokerMetricsGroup());
        groups.put(KafkaDataSetDef.MetricsTarget.CONSUMER, new ConsumerMetricsGroup());
        groups.put(KafkaDataSetDef.MetricsTarget.PRODUCER, new ProducerMetricsGroup());
    }
}

