/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.backend.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.ala.config.ProviderConfig;
import org.guvnor.ala.runtime.providers.Provider;
import org.guvnor.ala.services.api.backend.RuntimeProvisioningServiceBackend;
import org.guvnor.ala.ui.backend.service.converter.ProviderConverterFactory;
import org.guvnor.ala.ui.exceptions.ServiceException;
import org.guvnor.ala.ui.model.AbstractHasKeyObject;
import org.guvnor.ala.ui.model.ProviderConfiguration;
import org.guvnor.ala.ui.model.ProviderKey;
import org.guvnor.ala.ui.model.ProviderType;
import org.guvnor.ala.ui.model.ProviderTypeKey;
import org.guvnor.ala.ui.service.ProviderService;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.soup.commons.validation.PortablePreconditions;

@Service
@ApplicationScoped
public class ProviderServiceImpl
implements ProviderService {
    private RuntimeProvisioningServiceBackend runtimeProvisioningService;
    private ProviderConverterFactory providerConverterFactory;

    public ProviderServiceImpl() {
    }

    @Inject
    public ProviderServiceImpl(RuntimeProvisioningServiceBackend runtimeProvisioningService, ProviderConverterFactory providerConverterFactory) {
        this.runtimeProvisioningService = runtimeProvisioningService;
        this.providerConverterFactory = providerConverterFactory;
    }

    public Collection<org.guvnor.ala.ui.model.Provider> getProviders(ProviderType providerType) {
        PortablePreconditions.checkNotNull((String)"providerType", (Object)providerType);
        return this.getAllProviders().stream().filter(provider -> ((ProviderKey)provider.getKey()).getProviderTypeKey().equals(providerType.getKey())).collect(Collectors.toList());
    }

    public Collection<ProviderKey> getProvidersKey(ProviderType providerType) {
        return this.getProviders(providerType).stream().map(AbstractHasKeyObject::getKey).collect(Collectors.toList());
    }

    public void createProvider(ProviderType providerType, ProviderConfiguration configuration) {
        PortablePreconditions.checkNotNull((String)"providerType", (Object)providerType);
        PortablePreconditions.checkNotNull((String)"providerType.providerTypeKey", (Object)((ProviderTypeKey)providerType.getKey()));
        PortablePreconditions.checkNotNull((String)"configuration", (Object)configuration);
        PortablePreconditions.checkNotEmpty((String)"configuration.values", (Map)configuration.getValues());
        this.validateForCreateProvider(configuration);
        ProviderConfig providerConfig = (ProviderConfig)this.providerConverterFactory.getProviderConfigConverter((ProviderTypeKey)providerType.getKey()).toDomain(configuration);
        this.runtimeProvisioningService.registerProvider(providerConfig);
    }

    public void deleteProvider(ProviderKey providerKey) {
        this.runtimeProvisioningService.unregisterProvider(providerKey.getId());
    }

    public org.guvnor.ala.ui.model.Provider getProvider(ProviderKey providerKey) {
        List providers = this.runtimeProvisioningService.getProviders(Integer.valueOf(0), Integer.valueOf(1000), "providerTypeName", true);
        Optional<Object> result = Optional.empty();
        if (providers != null) {
            result = providers.stream().filter(provider -> provider.getId().equals(providerKey.getId())).map(this::convert).findFirst();
        }
        return result.orElse(null);
    }

    private Collection<org.guvnor.ala.ui.model.Provider> getAllProviders() {
        Collection<Object> result = new ArrayList<org.guvnor.ala.ui.model.Provider>();
        List providers = this.runtimeProvisioningService.getProviders(Integer.valueOf(0), Integer.valueOf(1000), "providerTypeName", true);
        if (providers != null) {
            result = providers.stream().map(this::convert).collect(Collectors.toList());
        }
        return result;
    }

    private org.guvnor.ala.ui.model.Provider convert(Provider provider) {
        return (org.guvnor.ala.ui.model.Provider)this.providerConverterFactory.getProviderConverter().toModel(provider);
    }

    private void validateForCreateProvider(ProviderConfiguration configuration) {
        for (org.guvnor.ala.ui.model.Provider provider : this.getAllProviders()) {
            if (!configuration.getId().equals(((ProviderKey)provider.getKey()).getId())) continue;
            throw new ServiceException("A provider with the given name already exists: " + configuration.getId());
        }
    }
}

