/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.kie.workbench.common.screens.library.api.SpacesScreenService;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.security.Contributor;
import org.uberfire.security.ContributorType;

@ApplicationScoped
public class SpacesScreenServiceImpl
implements SpacesScreenService {
    private OrganizationalUnitService organizationalUnitService;
    private SessionInfo sessionInfo;

    public SpacesScreenServiceImpl() {
    }

    @Inject
    public SpacesScreenServiceImpl(OrganizationalUnitService organizationalUnitService, SessionInfo sessionInfo) {
        this.organizationalUnitService = organizationalUnitService;
        this.sessionInfo = sessionInfo;
    }

    public Collection<OrganizationalUnit> getSpaces() {
        return this.organizationalUnitService.getOrganizationalUnits(true);
    }

    public OrganizationalUnit getSpace(String name) {
        return this.organizationalUnitService.getOrganizationalUnit(name, true);
    }

    public boolean isValidGroupId(String groupId) {
        return this.organizationalUnitService.isValidGroupId(groupId);
    }

    public Response postSpace(SpacesScreenService.NewSpace newSpace) {
        this.organizationalUnitService.createOrganizationalUnit(newSpace.name, newSpace.groupId, new ArrayList(), this.getContributors(), newSpace.description);
        return Response.status((int)201).build();
    }

    private List<Contributor> getContributors() {
        ArrayList<Contributor> contributors = new ArrayList<Contributor>();
        contributors.add(new Contributor(this.sessionInfo.getIdentity().getIdentifier(), ContributorType.OWNER));
        return contributors;
    }
}

