/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.builder.ala;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import org.guvnor.ala.config.BuildConfig;
import org.guvnor.ala.config.Config;
import org.guvnor.ala.pipeline.BiFunctionConfigExecutor;
import org.kie.workbench.common.services.backend.builder.ala.LocalBuildConfig;
import org.kie.workbench.common.services.backend.builder.ala.LocalBuildConfigInternal;
import org.kie.workbench.common.services.backend.builder.ala.LocalModule;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.workbench.events.ResourceChange;
import org.uberfire.workbench.events.ResourceChangeType;

@ApplicationScoped
public class LocalBuildConfigExecutor
implements BiFunctionConfigExecutor<LocalModule, LocalBuildConfig, BuildConfig> {
    public Optional<BuildConfig> apply(LocalModule localModule, LocalBuildConfig localBuildConfig) {
        Optional<BuildConfig> result = Optional.empty();
        LocalBuildConfig.BuildType buildType = this.decodeBuildType(localBuildConfig.getBuildType());
        switch (buildType) {
            case FULL_BUILD: {
                result = Optional.of(new LocalBuildConfigInternal(localModule.getModule()));
                break;
            }
            case INCREMENTAL_ADD_RESOURCE: 
            case INCREMENTAL_DELETE_RESOURCE: 
            case INCREMENTAL_UPDATE_RESOURCE: {
                result = Optional.of(new LocalBuildConfigInternal(localModule.getModule(), buildType, this.decodePath(localBuildConfig.getResource())));
                break;
            }
            case INCREMENTAL_BATCH_CHANGES: {
                result = Optional.of(new LocalBuildConfigInternal(localModule.getModule(), this.getResourceChanges(localBuildConfig.getResourceChanges())));
                break;
            }
            case FULL_BUILD_AND_DEPLOY: {
                result = Optional.of(new LocalBuildConfigInternal(localModule.getModule(), this.decodeDeploymentType(localBuildConfig.getDeploymentType()), this.decodeSuppressHandlers(localBuildConfig.getSuppressHandlers())));
            }
        }
        return result;
    }

    public Class<? extends Config> executeFor() {
        return LocalBuildConfig.class;
    }

    public String outputId() {
        return "local-build";
    }

    private LocalBuildConfig.BuildType decodeBuildType(String value) {
        return LocalBuildConfig.BuildType.valueOf(value);
    }

    private Map<Path, Collection<ResourceChange>> getResourceChanges(Map<String, String> input) {
        HashMap<Path, Collection<ResourceChange>> resourceChanges = new HashMap<Path, Collection<ResourceChange>>();
        input.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("resource-change:")).forEach(entry -> resourceChanges.put(this.decodePath((String)entry.getKey(), "resource-change:"), this.decodeChanges((String)entry.getValue())));
        return resourceChanges;
    }

    private Collection<ResourceChange> decodeChanges(String value) {
        return Arrays.stream(value.split(",")).map(s -> new ResourceChange((String)s){
            final /* synthetic */ String val$s;
            {
                this.val$s = string;
            }

            public ResourceChangeType getType() {
                return ResourceChangeType.valueOf((String)this.val$s.trim());
            }

            public String getMessage() {
                return null;
            }
        }).collect(Collectors.toList());
    }

    private Path decodePath(String uri) {
        return this.decodePath(uri, "");
    }

    private Path decodePath(String uri, String prefix) {
        String name = uri.substring(uri.lastIndexOf(47) + 1, uri.length());
        String decodedURI = uri.substring(prefix.length(), uri.length());
        return PathFactory.newPath((String)name, (String)decodedURI);
    }

    private LocalBuildConfig.DeploymentType decodeDeploymentType(String value) {
        return LocalBuildConfig.DeploymentType.valueOf(value);
    }

    private boolean decodeSuppressHandlers(String suppressHandlers) {
        return Boolean.parseBoolean(suppressHandlers);
    }
}

