/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.fasterxml.jackson.annotation.JsonProperty;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.kohsuke.github.GHApp;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.GitUser;

@SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD", "NP_UNWRITTEN_FIELD", "URF_UNREAD_FIELD"}, justification="JSON API")
public class GHCheckSuite
extends GHObject {
    @JsonProperty(value="repository")
    GHRepository owner;
    private String nodeId;
    private String headBranch;
    private String headSha;
    private String status;
    private String conclusion;
    private String before;
    private String after;
    private int latestCheckRunsCount;
    private String checkRunsUrl;
    private HeadCommit headCommit;
    private GHApp app;
    private GHPullRequest[] pullRequests;

    GHCheckSuite wrap(GHRepository owner) {
        this.owner = owner;
        this.wrap(owner.root());
        return this;
    }

    GHCheckSuite wrap(GitHub root) {
        if (this.owner != null && this.pullRequests != null && this.pullRequests.length != 0) {
            for (GHPullRequest singlePull : this.pullRequests) {
                singlePull.wrap(this.owner);
            }
        }
        return this;
    }

    GHPullRequest[] wrap() {
        return this.pullRequests;
    }

    @Override
    public String getNodeId() {
        return this.nodeId;
    }

    public String getHeadBranch() {
        return this.headBranch;
    }

    public String getHeadSha() {
        return this.headSha;
    }

    public String getStatus() {
        return this.status;
    }

    public String getConclusion() {
        return this.conclusion;
    }

    public String getBefore() {
        return this.before;
    }

    public String getAfter() {
        return this.after;
    }

    public int getLatestCheckRunsCount() {
        return this.latestCheckRunsCount;
    }

    public URL getCheckRunsUrl() {
        return GitHubClient.parseURL(this.checkRunsUrl);
    }

    public HeadCommit getHeadCommit() {
        return this.headCommit;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected behavior")
    public GHApp getApp() {
        return this.app;
    }

    public List<GHPullRequest> getPullRequests() throws IOException {
        if (this.pullRequests != null && this.pullRequests.length != 0) {
            for (GHPullRequest singlePull : this.pullRequests) {
                singlePull.refresh(singlePull.getTitle());
            }
            return Collections.unmodifiableList(Arrays.asList(this.pullRequests));
        }
        return Collections.emptyList();
    }

    @Override
    public URL getHtmlUrl() {
        return null;
    }

    public static class HeadCommit {
        private String id;
        private String treeId;
        private String message;
        private String timestamp;
        private GitUser author;
        private GitUser committer;

        public String getId() {
            return this.id;
        }

        public String getTreeId() {
            return this.treeId;
        }

        public String getMessage() {
            return this.message;
        }

        public Date getTimestamp() {
            return GitHubClient.parseDate(this.timestamp);
        }

        public GitUser getAuthor() {
            return this.author;
        }

        public GitUser getCommitter() {
            return this.committer;
        }
    }
}

