/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.kohsuke.github.GHAppInstallation;
import org.kohsuke.github.GHEvent;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.Requester;
import org.kohsuke.github.internal.EnumUtils;

public class GHApp
extends GHObject {
    private GHUser owner;
    private String name;
    private String slug;
    private String description;
    private String externalUrl;
    private Map<String, String> permissions;
    private List<String> events;
    private long installationsCount;
    private String htmlUrl;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected behavior")
    public GHUser getOwner() {
        return this.owner;
    }

    @Deprecated
    public void setOwner(GHUser owner) {
        throw new RuntimeException("Do not use this method.");
    }

    public String getName() {
        return this.name;
    }

    public String getSlug() {
        return this.slug;
    }

    @Deprecated
    public void setName(String name) {
        throw new RuntimeException("Do not use this method.");
    }

    public String getDescription() {
        return this.description;
    }

    @Deprecated
    public void setDescription(String description) {
        throw new RuntimeException("Do not use this method.");
    }

    public String getExternalUrl() {
        return this.externalUrl;
    }

    @Deprecated
    public void setExternalUrl(String externalUrl) {
        throw new RuntimeException("Do not use this method.");
    }

    public List<GHEvent> getEvents() {
        return this.events.stream().map(e -> EnumUtils.getEnumOrDefault(GHEvent.class, e, GHEvent.UNKNOWN)).collect(Collectors.toList());
    }

    @Deprecated
    public void setEvents(List<GHEvent> events) {
        throw new RuntimeException("Do not use this method.");
    }

    public long getInstallationsCount() {
        return this.installationsCount;
    }

    @Deprecated
    public void setInstallationsCount(long installationsCount) {
        throw new RuntimeException("Do not use this method.");
    }

    @Override
    public URL getHtmlUrl() {
        return GitHubClient.parseURL(this.htmlUrl);
    }

    public Map<String, String> getPermissions() {
        return Collections.unmodifiableMap(this.permissions);
    }

    @Deprecated
    public void setPermissions(Map<String, String> permissions) {
        throw new RuntimeException("Do not use this method.");
    }

    public PagedIterable<GHAppInstallation> listInstallations() {
        return this.listInstallations(null);
    }

    public PagedIterable<GHAppInstallation> listInstallations(Date since) {
        Requester requester = (Requester)this.root().createRequest().withUrlPath("/app/installations", new String[0]);
        if (since != null) {
            requester.with("since", GitHubClient.printDate(since));
        }
        return requester.toIterable(GHAppInstallation[].class, null);
    }

    public GHAppInstallation getInstallationById(long id) throws IOException {
        return ((Requester)this.root().createRequest().withUrlPath(String.format("/app/installations/%d", id), new String[0])).fetch(GHAppInstallation.class);
    }

    public GHAppInstallation getInstallationByOrganization(String name) throws IOException {
        return ((Requester)this.root().createRequest().withUrlPath(String.format("/orgs/%s/installation", name), new String[0])).fetch(GHAppInstallation.class);
    }

    public GHAppInstallation getInstallationByRepository(String ownerName, String repositoryName) throws IOException {
        return ((Requester)this.root().createRequest().withUrlPath(String.format("/repos/%s/%s/installation", ownerName, repositoryName), new String[0])).fetch(GHAppInstallation.class);
    }

    public GHAppInstallation getInstallationByUser(String name) throws IOException {
        return ((Requester)this.root().createRequest().withUrlPath(String.format("/users/%s/installation", name), new String[0])).fetch(GHAppInstallation.class);
    }
}

