/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.graph_layouter.impl;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.kohsuke.graph_layouter.impl.Level;
import org.kohsuke.graph_layouter.impl.LevelDirection;
import org.kohsuke.graph_layouter.impl.LevelMap;
import org.kohsuke.graph_layouter.impl.Vertex;
import org.kohsuke.graph_layouter.impl.WeightedVertex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Coordinator {
    private final int xGap = 10;
    private final int yGap = 10;
    private static final int MAX_ITERATION = 8;
    private static final int NO_BARYCENTER = Integer.MIN_VALUE;
    private static final Logger LOGGER = Logger.getLogger(Coordinator.class.getName());

    public <T> void layout(LevelMap<T> lm) {
        long before;
        long after;
        this.initial(lm);
        if (LOGGER.isLoggable(java.util.logging.Level.FINE)) {
            LOGGER.fine("Initial cost=" + this.objective(lm));
            LOGGER.fine("Graph=\n" + lm);
        }
        LevelDirection dir = LevelDirection.DOWN;
        int i = 0;
        while (i < 8) {
            this.move(dir, lm);
            if (LOGGER.isLoggable(java.util.logging.Level.FINE)) {
                LOGGER.fine("After " + i + "th iteration, cost=" + this.objective(lm));
                LOGGER.fine("Graph=\n" + lm);
            }
            ++i;
            dir = dir.opposite();
        }
        do {
            before = this.objective(lm);
            this.move(LevelDirection.DOWN, lm);
            this.move(LevelDirection.UP, lm);
            after = this.objective(lm);
            if (!LOGGER.isLoggable(java.util.logging.Level.FINE)) continue;
            LOGGER.fine("cost: " + before + "=>" + after);
            LOGGER.fine("Graph=\n" + lm);
        } while (after < before);
    }

    private <T> void move(LevelDirection dir, LevelMap<T> lm) {
        Level<T> lv = dir.first(lm);
        while (dir.next(lv) != null) {
            this.move(lv, dir.next(lv), dir);
            lv = dir.next(lv);
        }
    }

    private <T> void move(Level<T> fixed, Level<T> next, LevelDirection dir) {
        StringBuilder buf = new StringBuilder();
        if (LOGGER.isLoggable(java.util.logging.Level.FINER)) {
            buf.append("fixed=").append(fixed).append(',').append("next=").append(next);
        }
        ArrayList plist = new ArrayList();
        for (Vertex vertex : next.vertices) {
            plist.add(new WeightedVertex(this.getPriority(vertex, dir, fixed), vertex));
        }
        Collections.sort(plist, Collections.reverseOrder());
        for (WeightedVertex weightedVertex : plist) {
            int amount;
            int bc = this.getBarycenter(weightedVertex.v, dir);
            int xpos = weightedVertex.v.pos.x;
            if (bc == Integer.MIN_VALUE || bc == xpos) continue;
            if (bc > xpos) {
                amount = Math.min(bc - xpos, this.findSlack(weightedVertex.weight, this.reverse(next.vertices.subList(weightedVertex.v.order, plist.size())), dir, fixed));
                this.shiftRight(next.vertices.subList(weightedVertex.v.order, plist.size()), amount);
                continue;
            }
            amount = Math.min(xpos - bc, this.findSlack(weightedVertex.weight, next.vertices.subList(0, weightedVertex.v.order + 1), dir, fixed));
            this.shiftLeft(next.vertices.subList(0, weightedVertex.v.order + 1), amount);
        }
        if (LOGGER.isLoggable(java.util.logging.Level.FINER)) {
            buf.append("=>").append(next);
            LOGGER.finer(buf.toString());
        }
    }

    private <T> void shiftRight(List<Vertex<T>> vertices, int amount) {
        if (vertices.isEmpty()) {
            return;
        }
        int sz = vertices.size();
        int x = vertices.get((int)0).pos.x + amount;
        for (int i = 0; i < sz; ++i) {
            Vertex<T> v = vertices.get(i);
            if (x <= v.pos.x) {
                return;
            }
            v.pos.x = x;
            if (i + 1 >= sz) continue;
            Vertex<T> w = vertices.get(i + 1);
            x += v.size.width / 2 + 10 + w.size.width / 2;
        }
    }

    private <T> void shiftLeft(List<Vertex<T>> vertices, int amount) {
        if (vertices.isEmpty()) {
            return;
        }
        int sz = vertices.size();
        int x = vertices.get((int)(sz - 1)).pos.x - amount;
        for (int i = sz - 1; i >= 0; --i) {
            Vertex<T> v = vertices.get(i);
            if (x >= v.pos.x) {
                return;
            }
            v.pos.x = x;
            if (i <= 0) continue;
            Vertex<T> w = vertices.get(i - 1);
            x -= v.size.width / 2 + 10 + w.size.width / 2;
        }
    }

    private <T> int findSlack(float weight, List<Vertex<T>> vertices, LevelDirection dir, Level<T> fixed) {
        assert (!vertices.isEmpty());
        Vertex<T> tail = vertices.get(vertices.size() - 1);
        int width = Integer.MAX_VALUE;
        Vertex<T> last = null;
        for (Vertex<T> w : vertices) {
            if ((float)this.getPriority(w, dir, fixed) >= weight && w != tail) {
                width = 0;
            } else if (last != null) {
                width = Math.max(width, width + this.findSlack(last, w));
            }
            last = w;
        }
        return width;
    }

    private <T> int findSlack(Vertex<T> w, Vertex<T> v) {
        assert (Math.abs(v.order - w.order) == 1);
        int dist = Math.abs(w.pos.x - v.pos.x);
        assert ((dist -= v.size.width / 2 + w.size.width / 2 + 10) >= 0);
        return dist;
    }

    private <T> int getBarycenter(Vertex<T> v, LevelDirection dir) {
        int sumx = 0;
        Set<Vertex<T>> be = dir.backwardEdges(v);
        if (be.isEmpty()) {
            return Integer.MIN_VALUE;
        }
        for (Vertex<T> w : be) {
            sumx += w.pos.x;
        }
        return sumx / be.size();
    }

    private <T> int getPriority(Vertex<T> v, LevelDirection dir, Level<T> fixed) {
        if (v.isDummy() && dir.backwardEdges(v).iterator().next().isDummy()) {
            return fixed.vertices.size() + 1;
        }
        return dir.backwardEdges(v).size();
    }

    private <T> long objective(LevelMap<T> lm) {
        long closeness = 0L;
        long balanced = 0L;
        Level<T> lv = lm.first();
        while (lv.next() != null) {
            for (Vertex v : lv.vertices) {
                for (Vertex w : v.forward) {
                    closeness += (long)this.pow(v.pos.x - w.pos.x);
                }
                if (v.backward.size() > 1) {
                    int bc = this.getBarycenter(v, LevelDirection.DOWN);
                    assert (bc != Integer.MIN_VALUE);
                    balanced += (long)this.pow(bc - v.pos.x);
                }
                if (v.forward.size() <= 1) continue;
                int bc = this.getBarycenter(v, LevelDirection.UP);
                assert (bc != Integer.MIN_VALUE);
                balanced += (long)this.pow(bc - v.pos.x);
            }
            lv = lv.next();
        }
        return closeness + balanced;
    }

    private int pow(int x) {
        return x * x;
    }

    private <T> void initial(LevelMap<T> lm) {
        int y = 0;
        for (Level<T> lv : lm.levels()) {
            int x = 0;
            int ysz = 0;
            for (Vertex v : lv.vertices) {
                ysz = Math.max(ysz, v.size.height);
                v.pos.y = y;
                v.pos.x = x + v.size.width / 2;
                x += v.size.width + 10;
            }
            y += ysz + 10;
        }
    }

    private <T> List<T> reverse(final List<T> l) {
        return new AbstractList<T>(){
            final int sz;
            {
                this.sz = l.size();
            }

            @Override
            public T get(int index) {
                return l.get(this.sz - index - 1);
            }

            @Override
            public int size() {
                return this.sz;
            }
        };
    }
}

