/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.core;

import com.iwombat.foundation.IdentifierFactory;
import com.iwombat.util.GUIDUtil;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.ServerSocketChannel;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.core.JIComOxidDetails;
import org.jinterop.dcom.core.JIComOxidRuntimeHelper;
import org.jinterop.dcom.core.JIComOxidStub;
import org.jinterop.dcom.core.JIInterfacePointer;
import org.jinterop.dcom.core.JILocalCoClass;
import org.jinterop.dcom.core.JIObjectId;
import org.jinterop.dcom.core.JIOxid;
import org.jinterop.dcom.core.JISession;
import org.jinterop.dcom.core.JISetId;
import org.jinterop.dcom.core.JIStdObjRef;

final class JIComOxidRuntime {
    private static Properties defaults = new Properties();
    private static Properties defaults2 = new Properties();
    private static boolean stopSystem = false;
    private static boolean resolverStarted = false;
    private static ArrayList listOfSockets = new ArrayList();
    private static int oxidResolverPort = -1;
    private static HashMap mapOfIPIDVsComponent = new HashMap();
    private static HashMap mapOfJavaVsOxidDetails = new HashMap();
    private static HashMap mapOfOxidVsOxidDetails = new HashMap();
    private static HashMap mapOfOIDVsComponents = new HashMap();
    private static HashMap mapOfSessionIdsVsOIDs = new HashMap();
    private static HashMap mapOfSetIdVsListOfOIDs = new HashMap();
    private static HashMap mapOfSessionVsPingSetHolder = new HashMap();
    private static HashMap mapOfAddressVsStub = new HashMap();
    private static List listOfExportedJavaComponents = new ArrayList();
    static final Object mutex = new Object();
    private static final Object mutex2 = new Object();
    private static final Object mutex3 = new Object();
    private static ServerSocket serverSocket = null;
    private static Random randomGen = new Random(Double.doubleToRawLongBits(Math.random()));
    private static Timer pingTimer_2minutes = new Timer(true);
    private static Timer pingTimer_8minutes = new Timer(true);

    static {
        ((Hashtable)defaults2).put("rpc.ntlm.lanManagerKey", "false");
        ((Hashtable)defaults2).put("rpc.ntlm.sign", "false");
        ((Hashtable)defaults2).put("rpc.ntlm.seal", "false");
        ((Hashtable)defaults2).put("rpc.ntlm.keyExchange", "false");
        ((Hashtable)defaults2).put("rpc.connectionContext", "org.jinterop.dcom.transport.JIComRuntimeNTLMConnectionContext");
        ((Hashtable)defaults).put("rpc.connectionContext", "org.jinterop.dcom.transport.JIComRuntimeConnectionContext");
    }

    JIComOxidRuntime() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void destroySessionOIDs(int sessionId) {
        Object object = mutex2;
        synchronized (object) {
            ArrayList oids;
            if (JISystem.getLogger().isLoggable(Level.INFO)) {
                JISystem.getLogger().info("destroySessionOIDs for session: " + sessionId);
            }
            if ((oids = (ArrayList)mapOfSessionIdsVsOIDs.remove(new Integer(sessionId))) == null || oids.isEmpty()) {
                return;
            }
            int i = 0;
            while (i < oids.size()) {
                JIObjectId oid = (JIObjectId)oids.get(i);
                JILocalCoClass component = (JILocalCoClass)mapOfOIDVsComponents.remove(oid);
                JIComOxidDetails details = (JIComOxidDetails)mapOfJavaVsOxidDetails.get(component);
                if (details != null) {
                    mapOfOxidVsOxidDetails.remove(details.getOxid());
                    mapOfIPIDVsComponent.remove(details.getIpid());
                }
                mapOfJavaVsOxidDetails.remove(component);
                listOfExportedJavaComponents.remove(component);
                if (details != null) {
                    details.interruptRemUnknownThreadGroup();
                }
                component = null;
                details = null;
                oid = null;
                ++i;
            }
            oids.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addUpdateOXIDs(JISession session, String IPID, JIObjectId oid) {
        Object object = mutex3;
        synchronized (object) {
            PingSetHolder holder = (PingSetHolder)mapOfSessionVsPingSetHolder.get(session);
            if (holder == null) {
                holder = new PingSetHolder();
                holder.username = session.getUserName();
                holder.password = session.getPassword();
                holder.domain = session.getDomain();
                holder.currentSetOIDs.add(oid);
                holder.modified = true;
                holder.seqNum = 0;
                mapOfSessionVsPingSetHolder.put(session, holder);
            } else {
                int index = holder.currentSetOIDs.indexOf(oid);
                if (index != -1) {
                    oid = (JIObjectId)holder.currentSetOIDs.get(index);
                } else {
                    if (JISystem.getLogger().isLoggable(Level.INFO)) {
                        JISystem.getLogger().info("addUpdateOXIDs: Adding OID to holder " + holder + ", current size of currentSetOIDs is " + holder.currentSetOIDs.size());
                    }
                    holder.currentSetOIDs.add(oid);
                    holder.modified = true;
                }
            }
            oid.incrementIPIDRefCountBy1();
            if (JISystem.getLogger().isLoggable(Level.INFO)) {
                JISystem.getLogger().info("addUpdateOXIDs: finally this oid is " + oid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void delIPIDReference(String IPID, JIObjectId oid, JISession session) {
        Object object = mutex3;
        synchronized (object) {
            PingSetHolder holder = (PingSetHolder)mapOfSessionVsPingSetHolder.get(session);
            if (holder != null) {
                int index = holder.currentSetOIDs.indexOf(oid);
                if (index == -1) {
                    if (JISystem.getLogger().isLoggable(Level.WARNING)) {
                        JISystem.getLogger().warning("In delIPIDReference: Could not find Original OID for this temp OID for session: " + session.getSessionIdentifier() + " , temp oid is " + oid + " , and IPID is " + IPID);
                    }
                    return;
                }
                oid = (JIObjectId)holder.currentSetOIDs.get(index);
                oid.decrementIPIDRefCountBy1();
                if (JISystem.getLogger().isLoggable(Level.INFO)) {
                    JISystem.getLogger().info("delIPIDReference: Decrementing reference count for IPID " + IPID + " on OID " + oid);
                }
                if (oid.getIPIDRefCount() <= 0 && JISystem.getLogger().isLoggable(Level.INFO)) {
                    JISystem.getLogger().info("delIPIDReference: Ref count is <= 0, for OID " + oid);
                }
            } else if (JISystem.getLogger().isLoggable(Level.WARNING)) {
                JISystem.getLogger().warning("In delIPIDReference: Could not find PingSetHolder for this session: " + session.getSessionIdentifier() + " , temp oid is " + oid + " , and IPID is " + IPID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearIPIDsforSession(JISession session) {
        Object object = mutex3;
        synchronized (object) {
            PingSetHolder holder = (PingSetHolder)mapOfSessionVsPingSetHolder.get(session);
            if (holder != null) {
                if (JISystem.getLogger().isLoggable(Level.INFO)) {
                    JISystem.getLogger().info("clearIPIDsforSession: holder.currentSetOIDs's size is " + holder.currentSetOIDs.size());
                }
                int i = 0;
                while (i < holder.currentSetOIDs.size()) {
                    JIObjectId oid = (JIObjectId)holder.currentSetOIDs.get(i);
                    oid.setIPIDRefCountTo0();
                    ++i;
                }
                holder.modified = true;
                holder.currentSetOIDs.clear();
                holder.closed = true;
            }
        }
    }

    static synchronized void startResolverTimer() {
        pingTimer_2minutes.scheduleAtFixedRate((TimerTask)new ClientPingTimerTask(), 0L, 120000L);
        if (JISystem.isJavaCoClassAutoCollectionSet()) {
            pingTimer_8minutes.scheduleAtFixedRate((TimerTask)new ServerPingTimerTask(), 0L, 480000L);
        }
    }

    static synchronized void startResolver() {
        if (resolverStarted) {
            return;
        }
        Runnable thread = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
                    JIComOxidRuntime.serverSocket = serverSocketChannel.socket();
                    serverSocket.bind(null);
                    oxidResolverPort = serverSocket.getLocalPort();
                    while (!stopSystem) {
                        Socket socket = serverSocket.accept();
                        listOfSockets.add(socket);
                        Object object = mutex;
                        synchronized (object) {
                            JISystem.internal_setSocket(socket);
                            Properties properties = new Properties(defaults);
                            ((Hashtable)properties).put("IID", "99fcfec4-5260-101b-bbcb-00aa0021347a:0.0".toUpperCase());
                            JIComOxidRuntimeHelper oxidResolver = new JIComOxidRuntimeHelper(properties);
                            oxidResolver.startOxid(socket.getLocalPort(), socket.getPort());
                        }
                    }
                }
                catch (IOException serverSocketChannel) {
                    // empty catch block
                }
                int i = 0;
                while (i < listOfSockets.size()) {
                    Socket s = (Socket)listOfSockets.get(i);
                    try {
                        s.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    ++i;
                }
            }
        };
        Thread thread2 = new Thread(thread, "jI_OxidResolver");
        thread2.setDaemon(true);
        thread2.start();
        resolverStarted = true;
    }

    static int getOxidResolverPort() {
        return oxidResolverPort;
    }

    static synchronized void stopResolver() {
        stopSystem = true;
        try {
            serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        pingTimer_2minutes.cancel();
        pingTimer_8minutes.cancel();
        Iterator itr = mapOfAddressVsStub.values().iterator();
        while (itr.hasNext()) {
            JIComOxidStub s = (JIComOxidStub)((Object)itr.next());
            s.close();
        }
        mapOfAddressVsStub.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static JIInterfacePointer getInterfacePointer(JISession session, JILocalCoClass component) throws JIException {
        JIInterfacePointer ptr = null;
        Object object = mutex2;
        synchronized (object) {
            if (component.isAlreadyExported()) {
                throw new JIException(4163);
            }
            component.setSession(session);
            String ipid = GUIDUtil.guidStringFromHexString((String)IdentifierFactory.createUniqueIdentifier().toHexString());
            String iid = component.isCoClassUnderRealIID() ? component.getCoClassIID() : "00000000-0000-0000-c000-000000000046";
            byte[] bytes = new byte[8];
            randomGen.nextBytes(bytes);
            JIOxid oxid = new JIOxid(bytes);
            byte[] bytes2 = new byte[8];
            randomGen.nextBytes(bytes2);
            JIObjectId oid = new JIObjectId(bytes2, false);
            component.setObjectId(oid.getOID());
            JIStdObjRef objref = new JIStdObjRef(ipid, oxid, oid);
            ptr = new JIInterfacePointer(iid, oxidResolverPort, objref);
            Properties properties = new Properties(defaults2);
            ((Hashtable)properties).put("IID", "00000131-0000-0000-C000-000000000046:0.0".toUpperCase());
            ((Hashtable)properties).put("rpc.ntlm.domain", session.getTargetServer());
            int protecttionLevel = 2;
            if (session.isSessionSecurityEnabled()) {
                protecttionLevel = 6;
                properties.setProperty("rpc.ntlm.seal", "true");
                properties.setProperty("rpc.ntlm.sign", "true");
                properties.setProperty("rpc.ntlm.keyExchange", "true");
                properties.setProperty("rpc.ntlm.keyLength", "128");
                properties.setProperty("rpc.ntlm.ntlm2", "true");
                properties.setProperty("rpc.security.username", session.getUserName());
                properties.setProperty("rpc.security.password", session.getPassword());
                properties.setProperty("rpc.ntlm.ntlm2", "true");
            }
            JIComOxidRuntimeHelper remUnknown = new JIComOxidRuntimeHelper(properties);
            JIComOxidDetails details = new JIComOxidDetails(component, oxid, oid, iid, ipid, ptr, remUnknown, protecttionLevel);
            mapOfJavaVsOxidDetails.put(component, details);
            mapOfOxidVsOxidDetails.put(oxid, details);
            mapOfOIDVsComponents.put(oid, component);
            listOfExportedJavaComponents.add(component);
            mapOfIPIDVsComponent.put(ipid, details);
            ArrayList<JIObjectId> oids = (ArrayList<JIObjectId>)mapOfSessionIdsVsOIDs.get(new Integer(session.getSessionIdentifier()));
            if (oids == null) {
                oids = new ArrayList<JIObjectId>();
                mapOfSessionIdsVsOIDs.put(new Integer(session.getSessionIdentifier()), oids);
            }
            oids.add(oid);
            component.setAssociatedInterfacePointer(ptr);
        }
        return ptr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static JIComOxidDetails getOxidDetails(JIOxid oxid) {
        Object object = mutex2;
        synchronized (object) {
            return (JIComOxidDetails)mapOfOxidVsOxidDetails.get(oxid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static JIComOxidDetails getComponentFromIPID(String ipid) {
        Object object = mutex2;
        synchronized (object) {
            return (JIComOxidDetails)mapOfIPIDVsComponent.get(ipid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addUpdateSets(JISetId setId, ArrayList objectIdsAdded, ArrayList objectIdsDel) {
        Object object = mutex2;
        synchronized (object) {
            ArrayList listOfOIDs = (ArrayList)mapOfSetIdVsListOfOIDs.get(setId);
            if (listOfOIDs == null) {
                listOfOIDs = new ArrayList();
                listOfOIDs.addAll(objectIdsAdded);
                mapOfSetIdVsListOfOIDs.put(setId, listOfOIDs);
            } else {
                int i = 0;
                while (i < listOfOIDs.size()) {
                    JIObjectId oid = (JIObjectId)listOfOIDs.get(i);
                    if (!objectIdsDel.contains(oid)) {
                        oid.updateLastPingTime();
                    }
                    ++i;
                }
                listOfOIDs.addAll(objectIdsAdded);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static JILocalCoClass getJavaComponentFromIPID(String ipid) {
        JILocalCoClass component = null;
        Object object = mutex2;
        synchronized (object) {
            int i = 0;
            while (i < listOfExportedJavaComponents.size()) {
                component = (JILocalCoClass)listOfExportedJavaComponents.get(i);
                if (component.getIIDFromIpid(ipid) != null) break;
                component = null;
                ++i;
            }
        }
        return component;
    }

    private static class ClientPingTimerTask
    extends TimerTask {
        private ClientPingTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Iterator itr = null;
            Object object = mutex3;
            synchronized (object) {
                itr = ((Map)mapOfSessionVsPingSetHolder.clone()).entrySet().iterator();
            }
            if (JISystem.getLogger().isLoggable(Level.INFO)) {
                JISystem.getLogger().info("Running ClientPingTimerTask !");
            }
            while (itr.hasNext()) {
                int n;
                Map.Entry entry = itr.next();
                PingSetHolder holder = (PingSetHolder)entry.getValue();
                String address = ((JISession)entry.getKey()).getTargetServer();
                JIComOxidStub stub = (JIComOxidStub)((Object)mapOfAddressVsStub.get(address));
                if (stub == null) {
                    stub = new JIComOxidStub(address, holder.domain, holder.username, holder.password);
                    mapOfAddressVsStub.put(address, stub);
                }
                ArrayList<JIObjectId> listOfAddedOIDs = new ArrayList<JIObjectId>();
                ArrayList<JIObjectId> listOfRemovedOIDs = new ArrayList<JIObjectId>();
                Object object2 = mutex3;
                synchronized (object2) {
                    Iterator itr2 = ((AbstractList)holder.currentSetOIDs).iterator();
                    while (itr2.hasNext()) {
                        JIObjectId oid = (JIObjectId)itr2.next();
                        if (oid.getIPIDRefCount() == 0) {
                            if (!oid.dontping) {
                                listOfRemovedOIDs.add(oid);
                                holder.pingedOnce.remove(oid);
                                holder.modified = true;
                            }
                            itr2.remove();
                            continue;
                        }
                        if (oid.dontping || holder.pingedOnce.containsKey(oid)) continue;
                        listOfAddedOIDs.add(oid);
                        holder.pingedOnce.put(oid, oid);
                        holder.modified = true;
                    }
                }
                if (JISystem.getLogger().isLoggable(Level.INFO)) {
                    JISystem.getLogger().info("Within ClientPingTimerTask: holder.currentSetOIDs, current size of which is " + holder.currentSetOIDs.size());
                }
                if (holder.setId == null) {
                    listOfRemovedOIDs.clear();
                }
                boolean isSimplePing = false;
                if (holder.setId != null && !holder.modified) {
                    isSimplePing = true;
                }
                byte[] byArray = holder.setId;
                if (isSimplePing) {
                    n = 0;
                } else {
                    int n2 = holder.seqNum;
                    n = n2;
                    holder.seqNum = n2 + 1;
                }
                holder.setId = stub.call(isSimplePing, byArray, listOfAddedOIDs, listOfRemovedOIDs, n);
                if (JISystem.getLogger().isLoggable(Level.FINEST)) {
                    JISystem.getLogger().info("Within ClientPingTimerTask: holder.seqNum " + holder.seqNum);
                }
                holder.modified = false;
                if (!holder.closed) continue;
                if (JISystem.getLogger().isLoggable(Level.INFO)) {
                    JISystem.getLogger().info("Within ClientPingTimerTask: Holder " + holder + " is empty, will remove this from mapOfSessionVsPingSetHolder, whose curent size is: " + mapOfSessionVsPingSetHolder.size());
                }
                itr.remove();
                Object object3 = mutex3;
                synchronized (object3) {
                    mapOfSessionVsPingSetHolder.remove(entry.getKey());
                }
            }
        }
    }

    private static class PingSetHolder {
        byte[] setId = null;
        String username = null;
        String password = null;
        String domain = null;
        boolean modified = false;
        boolean closed = false;
        int seqNum = 1;
        ArrayList currentSetOIDs = new ArrayList();
        Map pingedOnce = new HashMap();

        private PingSetHolder() {
        }

        public String toString() {
            return "SetID[" + this.setId + "] , currentSetOIDs[" + this.currentSetOIDs + "]";
        }
    }

    private static class ServerPingTimerTask
    extends TimerTask {
        private ServerPingTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = mutex2;
            synchronized (object) {
                if (JISystem.getLogger().isLoggable(Level.INFO)) {
                    JISystem.getLogger().info("Running ServerPingTimerTask !");
                }
                Iterator itr = mapOfOIDVsComponents.keySet().iterator();
                while (itr.hasNext()) {
                    JILocalCoClass component;
                    JIObjectId oid = (JIObjectId)itr.next();
                    if (!oid.hasExpired() || (component = (JILocalCoClass)mapOfOIDVsComponents.get(oid)).isAssociatedReferenceAlive()) continue;
                    JIComOxidDetails details = (JIComOxidDetails)mapOfJavaVsOxidDetails.get(component);
                    mapOfOxidVsOxidDetails.remove(details.getOxid());
                    mapOfIPIDVsComponent.remove(details.getIpid());
                    mapOfJavaVsOxidDetails.remove(component);
                    listOfExportedJavaComponents.remove(component);
                    itr.remove();
                    details.interruptRemUnknownThreadGroup();
                    component = null;
                    details = null;
                }
            }
        }
    }
}

