/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ezmorph.array;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import net.sf.ezmorph.MorphException;
import net.sf.ezmorph.Morpher;
import net.sf.ezmorph.array.AbstractArrayMorpher;
import org.apache.commons.lang.builder.HashCodeBuilder;

public final class ObjectArrayMorpher
extends AbstractArrayMorpher {
    private Morpher morpher;
    private Method morphMethod;
    private Class target;
    private Class targetArrayClass;

    public ObjectArrayMorpher(Morpher morpher) {
        super(false);
        this.setMorpher(morpher);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ObjectArrayMorpher)) {
            return false;
        }
        ObjectArrayMorpher other = (ObjectArrayMorpher)obj;
        return this.morpher.equals(other.morpher);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.morpher).toHashCode();
    }

    @Override
    public Object morph(Object array) {
        if (array == null) {
            return null;
        }
        if (array.getClass().isArray()) {
            int length = Array.getLength(array);
            int dims = this.getDimensions(array.getClass());
            int[] dimensions = this.createDimensions(dims, length);
            Object result = Array.newInstance(this.target, dimensions);
            if (dims == 1) {
                for (int index = 0; index < length; ++index) {
                    try {
                        Object value = Array.get(array, index);
                        if (value != null && !this.morpher.supports(value.getClass())) {
                            throw new MorphException(value.getClass() + " is not supported");
                        }
                        Object morphed = this.morphMethod.invoke((Object)this.morpher, value);
                        Array.set(result, index, morphed);
                        continue;
                    }
                    catch (MorphException me) {
                        throw me;
                    }
                    catch (Exception e) {
                        throw new MorphException(e);
                    }
                }
            } else {
                for (int index = 0; index < length; ++index) {
                    Array.set(result, index, this.morph(Array.get(array, index)));
                }
            }
            return result;
        }
        throw new MorphException("argument is not an array: " + array.getClass());
    }

    @Override
    public Class morphsTo() {
        return this.targetArrayClass;
    }

    @Override
    public boolean supports(Class clazz) {
        if (clazz != null && !clazz.isArray()) {
            return false;
        }
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        return this.morpher.supports(clazz);
    }

    private void setMorpher(Morpher morpher) {
        if (morpher == null) {
            throw new IllegalArgumentException("morpher can not be null");
        }
        if (morpher.morphsTo().isArray()) {
            throw new IllegalArgumentException("morpher target class can not be an array");
        }
        this.morpher = morpher;
        this.targetArrayClass = Array.newInstance(morpher.morphsTo(), 1).getClass();
        this.target = morpher.morphsTo();
        try {
            this.morphMethod = morpher.getClass().getDeclaredMethod("morph", Object.class);
        }
        catch (NoSuchMethodException nsme) {
            throw new IllegalArgumentException(nsme.getMessage());
        }
    }
}

