/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import com.sun.mirror.apt.AnnotationProcessorFactory;
import com.sun.tools.apt.Main;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.CompilerError;
import org.codehaus.plexus.compiler.CompilerException;
import org.codehaus.plexus.compiler.javac.JavacCompiler;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.kohsuke.stapler.AnnotationProcessorFactoryImpl;

public class AptCompiler
extends JavacCompiler {
    public List compile(CompilerConfiguration config) throws CompilerException {
        String[] sourceFiles;
        config.setTargetVersion("1.5");
        config.setSourceVersion("1.5");
        File destinationDir = new File(config.getOutputLocation());
        if (!destinationDir.exists()) {
            destinationDir.mkdirs();
        }
        if ((sourceFiles = AptCompiler.getSourceFiles((CompilerConfiguration)config)).length == 0) {
            return Collections.EMPTY_LIST;
        }
        this.getLogger().info("Compiling " + sourceFiles.length + " " + "source file" + (sourceFiles.length == 1 ? "" : "s") + " to " + destinationDir.getAbsolutePath());
        if (config.isFork()) {
            config.addClasspathEntry(this.whichJar(AnnotationProcessorFactoryImpl.class));
            config.addCompilerCustomArgument("-factory", AnnotationProcessorFactoryImpl.class.getName());
        }
        config.addCompilerCustomArgument("-s", new File(config.getOutputLocation()).getAbsolutePath());
        String[] args = AptCompiler.buildCompilerArguments((CompilerConfiguration)config, (String[])sourceFiles);
        if (config.isFork()) {
            String executable = config.getExecutable();
            if (StringUtils.isEmpty((String)executable)) {
                File apt = new File(new File(System.getProperty("java.home")), "bin/apt");
                if (!apt.exists()) {
                    apt = new File(new File(System.getProperty("java.home")), "../bin/apt");
                }
                executable = apt.getAbsolutePath();
            }
            return this.compileOutOfProcess(config, executable, args);
        }
        return this.compileInProcess(args);
    }

    private String whichJar(Class c) throws CompilerException {
        try {
            String url = c.getClassLoader().getResource(c.getName().replace('.', '/') + ".class").toExternalForm();
            if (url.startsWith("jar:")) {
                url = url.substring(4);
                url = url.substring(0, url.indexOf(33));
                return new URL(url).getPath();
            }
            throw new CompilerException("Failed to infer classpath for " + c);
        }
        catch (MalformedURLException e) {
            throw new CompilerException("Failed to infer classpath for " + c, (Throwable)e);
        }
    }

    protected List compileInProcess(String[] args) throws CompilerException {
        Main aptTool = new Main();
        int r = Main.process((AnnotationProcessorFactory)new AnnotationProcessorFactoryImpl(), (PrintWriter)new PrintWriter(System.out, true), (String[])args);
        if (r != 0) {
            throw new CompilerException("APT failed: " + r);
        }
        return Collections.emptyList();
    }

    protected List compileOutOfProcess(CompilerConfiguration config, String executable, String[] args) throws CompilerException {
        List messages;
        int returnCode;
        Commandline cli = new Commandline();
        cli.setWorkingDirectory(config.getWorkingDirectory().getAbsolutePath());
        cli.setExecutable(executable);
        try {
            File argumentsFile = this.createFileWithArguments(args);
            cli.addArguments(new String[]{"@" + argumentsFile.getCanonicalPath().replace(File.separatorChar, '/')});
            if (!StringUtils.isEmpty((String)config.getMaxmem())) {
                cli.addArguments(new String[]{"-J-Xmx" + config.getMaxmem()});
            }
            if (!StringUtils.isEmpty((String)config.getMeminitial())) {
                cli.addArguments(new String[]{"-J-Xms" + config.getMeminitial()});
            }
        }
        catch (IOException e) {
            throw new CompilerException("Error creating file with javac arguments", (Throwable)e);
        }
        CommandLineUtils.StringStreamConsumer out = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer err = new CommandLineUtils.StringStreamConsumer();
        try {
            returnCode = CommandLineUtils.executeCommandLine((Commandline)cli, (StreamConsumer)out, (StreamConsumer)err);
            messages = AptCompiler.parseModernStream((BufferedReader)new BufferedReader(new StringReader(err.getOutput())));
        }
        catch (CommandLineException e) {
            throw new CompilerException("Error while executing the external compiler.", (Throwable)e);
        }
        catch (IOException e) {
            throw new CompilerException("Error while executing the external compiler.", (Throwable)e);
        }
        if (returnCode != 0 && messages.isEmpty()) {
            if (err.getOutput().length() == 0) {
                throw new CompilerException("Unknown error trying to execute the external compiler: " + EOL + cli.toString());
            }
            messages.add(new CompilerError("Failure executing javac,  but could not parse the error:" + EOL + err.getOutput(), true));
        }
        return messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createFileWithArguments(String[] args) throws IOException {
        PrintWriter writer = null;
        try {
            File tempFile = File.createTempFile(JavacCompiler.class.getName(), "arguments");
            tempFile.deleteOnExit();
            writer = new PrintWriter(new FileWriter(tempFile));
            for (int i = 0; i < args.length; ++i) {
                String argValue = args[i].replace(File.separatorChar, '/');
                writer.write("\"" + argValue + "\"");
                writer.write(EOL);
            }
            writer.flush();
            File file = tempFile;
            return file;
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }
}

