/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.jelly.groovy;

import groovy.lang.Binding;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassImpl;
import groovy.lang.MutableMetaClass;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.XMLOutput;
import org.codehaus.groovy.reflection.CachedClass;
import org.codehaus.groovy.reflection.CachedMethod;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.kohsuke.stapler.jelly.groovy.JellyBuilder;
import org.kohsuke.stapler.jelly.groovy.StaplerClosureScript;

public class GroovierJellyScript
implements Script {
    private final Class clazz;
    private final URL scriptURL;

    public GroovierJellyScript(Class clazz, URL scriptURL) {
        this.clazz = clazz;
        this.scriptURL = scriptURL;
    }

    public Script compile() {
        return this;
    }

    public void run(JellyContext context, XMLOutput output) throws JellyTagException {
        this.run(new JellyBuilder(context, output));
    }

    public void run(JellyBuilder builder) {
        StaplerClosureScript gcs;
        try {
            gcs = (StaplerClosureScript)InvokerHelper.createScript((Class)this.clazz, (Binding)new Binding());
        }
        catch (LinkageError e) {
            throw new LinkageError("Failed to run " + this.clazz + " from " + this.scriptURL, e);
        }
        gcs.setDelegate((GroovyObject)builder);
        MetaClassImpl metaClass = new MetaClassImpl(this.clazz);
        Arrays.stream(this.clazz.getMethods()).filter(method -> method.getName().equals("gettext")).map(CachedMethod::find).map(method -> new AliasMetaMethod(method.getDeclaringClass(), method.getCachedMethod(), "_")).forEach(arg_0 -> ((MutableMetaClass)metaClass).addMetaMethod(arg_0));
        metaClass.initialize();
        gcs.setMetaClass((MetaClass)metaClass);
        gcs.scriptURL = this.scriptURL;
        gcs.run();
    }

    private static final class AliasMetaMethod
    extends CachedMethod {
        private final String alias;

        AliasMetaMethod(CachedClass clazz, Method method, String alias) {
            super(clazz, method);
            this.alias = Objects.requireNonNull(alias);
        }

        public String getName() {
            return this.alias;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AliasMetaMethod that = (AliasMetaMethod)((Object)o);
            return Objects.equals(this.alias, that.alias);
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.alias);
        }
    }
}

