/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.jelly;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.Script;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.WebApp;
import org.kohsuke.stapler.jelly.JellyFacet;

public final class JellyRequestDispatcher
implements RequestDispatcher {
    private final Object it;
    private final Script script;
    private final JellyFacet facet;

    public JellyRequestDispatcher(Object it, Script script) {
        this.it = it;
        this.script = script;
        this.facet = (JellyFacet)WebApp.getCurrent().getFacet(JellyFacet.class);
    }

    public void forward(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        try {
            this.facet.scriptInvoker.invokeScript((StaplerRequest2)servletRequest, (StaplerResponse2)servletResponse, this.script, this.it);
        }
        catch (JellyTagException e) {
            throw new ServletException((Throwable)e);
        }
    }

    @SuppressFBWarnings(value={"REQUESTDISPATCHER_FILE_DISCLOSURE"}, justification="Forwarding the request to be handled correctly.")
    public void include(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        this.forward(servletRequest, servletResponse);
    }
}

