/*
 * Decompiled with CFR 0.152.
 */
package org.lesscss.mojo;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.lesscss.LessSource;
import org.lesscss.mojo.AbstractLessCssMojo;

public class ListMojo
extends AbstractLessCssMojo {
    public void execute() throws MojoExecutionException {
        String[] files;
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("sourceDirectory = " + this.sourceDirectory));
            this.getLog().debug((CharSequence)("includes = " + Arrays.toString(this.includes)));
            this.getLog().debug((CharSequence)("excludes = " + Arrays.toString(this.excludes)));
        }
        if ((files = this.getIncludedFiles()) == null || files.length < 1) {
            this.getLog().info((CharSequence)"No LESS sources found");
        } else {
            this.getLog().info((CharSequence)"The following LESS sources have been resolved:");
            for (String file : files) {
                File lessFile = new File(this.sourceDirectory, file);
                try {
                    LessSource lessSource = new LessSource(lessFile);
                    this.listLessSource(lessSource, file, 0, false);
                }
                catch (FileNotFoundException e) {
                    throw new MojoExecutionException("Error while loading LESS source: " + lessFile.getAbsolutePath(), (Exception)e);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Error while loading LESS source: " + lessFile.getAbsolutePath(), (Exception)e);
                }
            }
        }
    }

    private void listLessSource(LessSource lessSource, String path, int level, boolean last) {
        String prefix = "";
        if (level > 0) {
            for (int i = 1; i <= level; ++i) {
                prefix = i == level && last ? prefix + "`-- " : (i == level ? prefix + "|-- " : prefix + "|   ");
            }
        }
        this.getLog().info((CharSequence)(prefix + path));
        Iterator it = lessSource.getImports().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            this.listLessSource((LessSource)entry.getValue(), (String)entry.getKey(), level + 1, !it.hasNext());
        }
    }
}

